import { datatype, internet } from 'faker';
import { StreamType } from 'tachyon-more-ui';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory, randomId } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { StreamPreviewPlayer, VodPreviewPlayer } from '../../../player';
import { ProfilePlayerBase } from '.';

const channelWithNoStream = () => {
  return {
    stream: null,
  };
};

const channelWithNoStreamAndNoVod = () => {
  return {
    stream: null,
    videos: null,
  };
};

const channelWithHostedStream = () => {
  return {
    hosting: {
      id: validId(randomId()),
      login: internet.userName(),
      stream: {
        id: validId(randomId()),
        type: StreamType.Live,
      },
    },
    stream: null,
  };
};

describe(ProfilePlayerBase, () => {
  const setup = createShallowWrapperFactory(ProfilePlayerBase, () => ({
    channel: {
      ' $fragmentRefs': {
        StreamPreviewPlayer_channel: true,
      },
      ' $refType': 'ProfilePlayer_channel',
      hosting: null,
      id: validId(randomId()),
      login: internet.userName(),
      stream: {
        id: validId(randomId()),
        type: StreamType.Live,
        viewersCount: datatype.number(),
      },
      videos: {
        edges: [
          {
            node: {
              ' $fragmentRefs': {
                VodPlayerOverlay_video: true,
                VodPreviewPlayer_video: true,
              },
              id: validId(randomId()),
            },
          },
        ],
      },
    },
    currentUser: null,
    streamToken: {
      ' $fragmentRefs': { StreamPlayer_token: true },
    },
    vodPreviewToken: {
      ' $fragmentRefs': { VodPreviewPlayerWrapper_previewToken: true },
    },
  }));

  it('renders the stream player when there is a live stream', () => {
    const { wrapper } = setup();
    expect(wrapper.find(StreamPreviewPlayer)).toExist();
  });

  it('renders the stream player when there is a hosting stream', () => {
    const { wrapper } = setup({ channel: channelWithHostedStream() });
    expect(wrapper.find(StreamPreviewPlayer)).toExist();
  });

  it('renders the vod player when there is a no stream but a vod', () => {
    const { wrapper } = setup({ channel: channelWithNoStream() });
    expect(wrapper.find(VodPreviewPlayer)).toExist();
  });

  it('renders the offline state when there is no stream or vod', () => {
    const { wrapper } = setup({ channel: channelWithNoStreamAndNoVod() });
    expect(wrapper.find(StreamPreviewPlayer)).not.toExist();
    expect(wrapper.find(VodPreviewPlayer)).not.toExist();
    expect(wrapper.find(CoreText)).toExist();
  });
});
