import type { FC } from 'react';
import { FocusableClipCard, FocusableVodCard } from '../../../common';
import type { VodOrClipCard } from '../utils';

type VideoItemRendererProps = {
  focusIndex: number;
  node: VodOrClipCard;
};

// istanbul ignore next: trivial
export const VideoItemRenderer: FC<VideoItemRendererProps> = ({
  focusIndex,
  node,
}) => {
  return node.__typename === 'Clip' ? (
    <FocusableClipCard clip={node} focusIndex={focusIndex} />
  ) : (
    <FocusableVodCard focusIndex={focusIndex} video={node} />
  );
};

VideoItemRenderer.displayName = 'VideoItemRenderer';
