/* tslint:disable */
/* eslint-disable */
// @ts-nocheck

import { ConcreteRequest } from "relay-runtime";
import { FragmentRefs } from "relay-runtime";
export type ChannelHome_QueryVariables = {
    login: string;
    platform: string;
    playerType: string;
    skipPlayToken: boolean;
};
export type ChannelHome_QueryResponse = {
    readonly channel: {
        readonly id: string;
        readonly login: string;
        readonly stream: {
            readonly id: string;
        } | null;
        readonly videoShelves: {
            readonly edges: ReadonlyArray<{
                readonly node: {
                    readonly id: string;
                    readonly title: string;
                    readonly items: ReadonlyArray<{
                        readonly __typename: "Clip";
                        readonly " $fragmentRefs": FragmentRefs<"FocusableClipCard_clip">;
                    } | {
                        readonly __typename: "Video";
                        readonly " $fragmentRefs": FragmentRefs<"FocusableVodCard_video">;
                    } | {
                        /*This will never be '%other', but we need some
                        value in case none of the concrete values match.*/
                        readonly __typename: "%other";
                    }> | null;
                } | null;
            }> | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ProfileBanner_channel">;
    } | null;
    readonly currentUser: {
        readonly id: string;
        readonly login: string;
        readonly roles: {
            readonly isStaff: boolean | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ProfileBanner_currentUser">;
    } | null;
    readonly " $fragmentRefs": FragmentRefs<"StreamPlayer_token" | "VodPreviewPlayerWrapper_previewToken">;
};
export type ChannelHome_Query = {
    readonly response: ChannelHome_QueryResponse;
    readonly variables: ChannelHome_QueryVariables;
};



/*
query ChannelHome_Query(
  $login: String!
  $platform: String!
  $playerType: String!
  $skipPlayToken: Boolean!
) {
  channel: user(login: $login) {
    id
    login
    stream {
      id
    }
    videoShelves {
      edges {
        node {
          id
          title
          items {
            __typename
            __isVideoShelfItem: __typename
            ... on Clip {
              ...FocusableClipCard_clip
            }
            ... on Video {
              ...FocusableVodCard_video
            }
          }
        }
      }
    }
    ...ProfileBanner_channel
  }
  currentUser {
    ...ProfileBanner_currentUser
    id
    login
    roles {
      isStaff
    }
  }
  ...StreamPlayer_token
  ...VodPreviewPlayerWrapper_previewToken
}

fragment BannerButtonsRow_channel on User {
  ...FocusableFollowButton_channel
  displayName
  hosting {
    displayName
    id
    login
    stream {
      id
      type
    }
  }
  id
  login
  stream {
    id
    type
  }
  videos(first: 1, sort: TIME) {
    edges {
      node {
        id
      }
    }
  }
}

fragment BannerChannelStatus_channel on User {
  displayName
  hosting {
    displayName
    id
    login
    stream {
      id
      type
    }
  }
  id
  login
  stream {
    id
    type
  }
}

fragment FocusableClipCard_clip on Clip {
  broadcaster {
    login
    id
  }
  createdAt
  durationSeconds
  game {
    boxArtURL
    displayName
    id
  }
  id
  slug
  thumbnailURL
  title
  viewCount
}

fragment FocusableFollowButton_channel on User {
  login
  id
  self {
    follower {
      followedAt
    }
  }
}

fragment FocusableVodCard_video on Video {
  createdAt
  lengthSeconds
  game {
    boxArtURL
    displayName
    id
  }
  id
  previewThumbnailURL
  self {
    viewingHistory {
      position
    }
  }
  title
  viewCount
}

fragment ProfileBanner_channel on User {
  ...BannerButtonsRow_channel
  ...BannerChannelStatus_channel
  ...ProfilePlayer_channel
  description
  displayName
  followers {
    totalCount
  }
  hosting {
    id
    login
    profileImageURL(width: 70)
  }
  id
  login
  profileImageURL(width: 70)
  profileViewCount
}

fragment ProfileBanner_currentUser on User {
  ...ProfilePlayer_currentUser
}

fragment ProfilePlayer_channel on User {
  ...StreamPreviewPlayer_channel
  hosting {
    id
    login
    stream {
      id
      type
      viewersCount
    }
  }
  id
  login
  stream {
    id
    type
    viewersCount
  }
  videos(first: 1, sort: TIME) {
    edges {
      node {
        id
        ...VodPreviewPlayer_video
      }
    }
  }
}

fragment ProfilePlayer_currentUser on User {
  ...StreamPreviewPlayer_currentUser
  ...VodPreviewPlayer_currentUser
}

fragment StreamPlayer_channel on User {
  id
  login
  roles {
    isPartner
  }
  self {
    subscriptionBenefit {
      id
    }
  }
  stream {
    id
    game {
      name
      id
    }
    previewImageURL
  }
}

fragment StreamPlayer_currentUser on User {
  hasTurbo
  id
}

fragment StreamPlayer_token on Query {
  user(login: $login) {
    login
    stream @skip(if: $skipPlayToken) {
      playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {
        signature
        value
      }
      id
    }
    id
  }
}

fragment StreamPreviewPlayer_channel on User {
  hosting {
    ...StreamPlayer_channel
    id
    login
    stream {
      id
      type
      viewersCount
      previewImageURL
    }
  }
  ...StreamPlayer_channel
  id
  login
  stream {
    id
    type
    viewersCount
    previewImageURL
    restrictionType
    self {
      canWatch
    }
  }
  displayName
  broadcastSettings {
    isMature
    id
  }
}

fragment StreamPreviewPlayer_currentUser on User {
  ...StreamPlayer_currentUser
}

fragment VodPlayerBase_currentUser on User {
  id
  hasTurbo
}

fragment VodPlayerBase_video on Video {
  broadcastType
  id
  game {
    name
    id
  }
  owner {
    id
    login
    roles {
      isPartner
    }
    self {
      subscriptionBenefit {
        id
      }
    }
  }
  self {
    viewingHistory {
      position
    }
  }
}

fragment VodPlayerOverlay_video on Video {
  createdAt
  lengthSeconds
  viewCount
}

fragment VodPreviewPlayerWrapper_previewToken on Query {
  user(login: $login) @skip(if: $skipPlayToken) {
    videos(first: 1) {
      edges {
        node {
          playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {
            signature
            value
          }
          id
        }
      }
    }
    id
  }
}

fragment VodPreviewPlayer_currentUser on User {
  ...VodPlayerBase_currentUser
}

fragment VodPreviewPlayer_video on Video {
  ...VodPlayerBase_video
  ...VodPlayerOverlay_video
  muteInfo {
    mutedSegmentConnection {
      nodes {
        duration
      }
    }
  }
  owner {
    id
    login
    broadcastSettings {
      isMature
      id
    }
    subscriptionProducts {
      displayName
      hasSubonlyVideoArchive
      id
    }
    displayName
  }
  resourceRestriction {
    type
    id
  }
  self {
    isRestricted
  }
  previewThumbnailURL
}
*/

const node: ConcreteRequest = (function(){
var v0 = [
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "login"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "platform"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "playerType"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "skipPlayToken"
  }
],
v1 = [
  {
    "kind": "Variable",
    "name": "login",
    "variableName": "login"
  }
],
v2 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "id",
  "storageKey": null
},
v3 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "login",
  "storageKey": null
},
v4 = [
  (v2/*: any*/)
],
v5 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "title",
  "storageKey": null
},
v6 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "__typename",
  "storageKey": null
},
v7 = {
  "alias": null,
  "args": null,
  "concreteType": "UserRoles",
  "kind": "LinkedField",
  "name": "roles",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isStaff",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v8 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "type",
  "storageKey": null
},
v9 = {
  "alias": null,
  "args": null,
  "concreteType": "Game",
  "kind": "LinkedField",
  "name": "game",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "name",
      "storageKey": null
    },
    (v2/*: any*/)
  ],
  "storageKey": null
},
v10 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "previewImageURL",
  "storageKey": null
},
v11 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "viewersCount",
  "storageKey": null
},
v12 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "createdAt",
  "storageKey": null
},
v13 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "displayName",
  "storageKey": null
},
v14 = {
  "alias": null,
  "args": null,
  "concreteType": "Game",
  "kind": "LinkedField",
  "name": "game",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "boxArtURL",
      "storageKey": null
    },
    (v13/*: any*/),
    (v2/*: any*/)
  ],
  "storageKey": null
},
v15 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "viewCount",
  "storageKey": null
},
v16 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "lengthSeconds",
  "storageKey": null
},
v17 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "previewThumbnailURL",
  "storageKey": null
},
v18 = {
  "alias": null,
  "args": null,
  "concreteType": "VideoViewingHistory",
  "kind": "LinkedField",
  "name": "viewingHistory",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "position",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v19 = {
  "alias": null,
  "args": null,
  "concreteType": "SubscriptionBenefit",
  "kind": "LinkedField",
  "name": "subscriptionBenefit",
  "plural": false,
  "selections": (v4/*: any*/),
  "storageKey": null
},
v20 = {
  "alias": null,
  "args": null,
  "concreteType": "UserRoles",
  "kind": "LinkedField",
  "name": "roles",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isPartner",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v21 = {
  "alias": null,
  "args": null,
  "concreteType": "UserSelfConnection",
  "kind": "LinkedField",
  "name": "self",
  "plural": false,
  "selections": [
    (v19/*: any*/)
  ],
  "storageKey": null
},
v22 = {
  "alias": null,
  "args": [
    {
      "kind": "Literal",
      "name": "width",
      "value": 70
    }
  ],
  "kind": "ScalarField",
  "name": "profileImageURL",
  "storageKey": "profileImageURL(width:70)"
},
v23 = {
  "kind": "Literal",
  "name": "first",
  "value": 1
},
v24 = {
  "alias": null,
  "args": null,
  "concreteType": "BroadcastSettings",
  "kind": "LinkedField",
  "name": "broadcastSettings",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isMature",
      "storageKey": null
    },
    (v2/*: any*/)
  ],
  "storageKey": null
},
v25 = [
  {
    "alias": null,
    "args": [
      {
        "fields": [
          {
            "kind": "Variable",
            "name": "platform",
            "variableName": "platform"
          },
          {
            "kind": "Variable",
            "name": "playerType",
            "variableName": "playerType"
          }
        ],
        "kind": "ObjectValue",
        "name": "params"
      }
    ],
    "concreteType": "PlaybackAccessToken",
    "kind": "LinkedField",
    "name": "playbackAccessToken",
    "plural": false,
    "selections": [
      {
        "alias": null,
        "args": null,
        "kind": "ScalarField",
        "name": "signature",
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "kind": "ScalarField",
        "name": "value",
        "storageKey": null
      }
    ],
    "storageKey": null
  },
  (v2/*: any*/)
];
return {
  "fragment": {
    "argumentDefinitions": (v0/*: any*/),
    "kind": "Fragment",
    "metadata": null,
    "name": "ChannelHome_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": (v4/*: any*/),
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "VideoShelfConnection",
            "kind": "LinkedField",
            "name": "videoShelves",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "VideoShelfEdge",
                "kind": "LinkedField",
                "name": "edges",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoShelf",
                    "kind": "LinkedField",
                    "name": "node",
                    "plural": false,
                    "selections": [
                      (v2/*: any*/),
                      (v5/*: any*/),
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": null,
                        "kind": "LinkedField",
                        "name": "items",
                        "plural": true,
                        "selections": [
                          (v6/*: any*/),
                          {
                            "kind": "InlineFragment",
                            "selections": [
                              {
                                "args": null,
                                "kind": "FragmentSpread",
                                "name": "FocusableClipCard_clip"
                              }
                            ],
                            "type": "Clip",
                            "abstractKey": null
                          },
                          {
                            "kind": "InlineFragment",
                            "selections": [
                              {
                                "args": null,
                                "kind": "FragmentSpread",
                                "name": "FocusableVodCard_video"
                              }
                            ],
                            "type": "Video",
                            "abstractKey": null
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "ProfileBanner_channel"
          }
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          (v7/*: any*/),
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "ProfileBanner_currentUser"
          }
        ],
        "storageKey": null
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "StreamPlayer_token"
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "VodPreviewPlayerWrapper_previewToken"
      }
    ],
    "type": "Query",
    "abstractKey": null
  },
  "kind": "Request",
  "operation": {
    "argumentDefinitions": (v0/*: any*/),
    "kind": "Operation",
    "name": "ChannelHome_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              (v2/*: any*/),
              (v8/*: any*/),
              (v9/*: any*/),
              (v10/*: any*/),
              (v11/*: any*/),
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "restrictionType",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "StreamSelfConnection",
                "kind": "LinkedField",
                "name": "self",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "canWatch",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "VideoShelfConnection",
            "kind": "LinkedField",
            "name": "videoShelves",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "VideoShelfEdge",
                "kind": "LinkedField",
                "name": "edges",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoShelf",
                    "kind": "LinkedField",
                    "name": "node",
                    "plural": false,
                    "selections": [
                      (v2/*: any*/),
                      (v5/*: any*/),
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": null,
                        "kind": "LinkedField",
                        "name": "items",
                        "plural": true,
                        "selections": [
                          (v6/*: any*/),
                          {
                            "kind": "TypeDiscriminator",
                            "abstractKey": "__isVideoShelfItem"
                          },
                          {
                            "kind": "InlineFragment",
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "User",
                                "kind": "LinkedField",
                                "name": "broadcaster",
                                "plural": false,
                                "selections": [
                                  (v3/*: any*/),
                                  (v2/*: any*/)
                                ],
                                "storageKey": null
                              },
                              (v12/*: any*/),
                              {
                                "alias": null,
                                "args": null,
                                "kind": "ScalarField",
                                "name": "durationSeconds",
                                "storageKey": null
                              },
                              (v14/*: any*/),
                              (v2/*: any*/),
                              {
                                "alias": null,
                                "args": null,
                                "kind": "ScalarField",
                                "name": "slug",
                                "storageKey": null
                              },
                              {
                                "alias": null,
                                "args": null,
                                "kind": "ScalarField",
                                "name": "thumbnailURL",
                                "storageKey": null
                              },
                              (v5/*: any*/),
                              (v15/*: any*/)
                            ],
                            "type": "Clip",
                            "abstractKey": null
                          },
                          {
                            "kind": "InlineFragment",
                            "selections": [
                              (v12/*: any*/),
                              (v16/*: any*/),
                              (v14/*: any*/),
                              (v2/*: any*/),
                              (v17/*: any*/),
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "VideoSelfEdge",
                                "kind": "LinkedField",
                                "name": "self",
                                "plural": false,
                                "selections": [
                                  (v18/*: any*/)
                                ],
                                "storageKey": null
                              },
                              (v5/*: any*/),
                              (v15/*: any*/)
                            ],
                            "type": "Video",
                            "abstractKey": null
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "UserSelfConnection",
            "kind": "LinkedField",
            "name": "self",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "FollowerEdge",
                "kind": "LinkedField",
                "name": "follower",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "followedAt",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              (v19/*: any*/)
            ],
            "storageKey": null
          },
          (v13/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "hosting",
            "plural": false,
            "selections": [
              (v13/*: any*/),
              (v2/*: any*/),
              (v3/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  (v2/*: any*/),
                  (v8/*: any*/),
                  (v9/*: any*/),
                  (v10/*: any*/),
                  (v11/*: any*/)
                ],
                "storageKey": null
              },
              (v20/*: any*/),
              (v21/*: any*/),
              (v22/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": [
              (v23/*: any*/),
              {
                "kind": "Literal",
                "name": "sort",
                "value": "TIME"
              }
            ],
            "concreteType": "VideoConnection",
            "kind": "LinkedField",
            "name": "videos",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "VideoEdge",
                "kind": "LinkedField",
                "name": "edges",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "Video",
                    "kind": "LinkedField",
                    "name": "node",
                    "plural": false,
                    "selections": [
                      (v2/*: any*/),
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "broadcastType",
                        "storageKey": null
                      },
                      (v9/*: any*/),
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "User",
                        "kind": "LinkedField",
                        "name": "owner",
                        "plural": false,
                        "selections": [
                          (v2/*: any*/),
                          (v3/*: any*/),
                          (v20/*: any*/),
                          (v21/*: any*/),
                          (v24/*: any*/),
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "SubscriptionProduct",
                            "kind": "LinkedField",
                            "name": "subscriptionProducts",
                            "plural": true,
                            "selections": [
                              (v13/*: any*/),
                              {
                                "alias": null,
                                "args": null,
                                "kind": "ScalarField",
                                "name": "hasSubonlyVideoArchive",
                                "storageKey": null
                              },
                              (v2/*: any*/)
                            ],
                            "storageKey": null
                          },
                          (v13/*: any*/)
                        ],
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "VideoSelfEdge",
                        "kind": "LinkedField",
                        "name": "self",
                        "plural": false,
                        "selections": [
                          (v18/*: any*/),
                          {
                            "alias": null,
                            "args": null,
                            "kind": "ScalarField",
                            "name": "isRestricted",
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      },
                      (v12/*: any*/),
                      (v16/*: any*/),
                      (v15/*: any*/),
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "VideoMuteInfo",
                        "kind": "LinkedField",
                        "name": "muteInfo",
                        "plural": false,
                        "selections": [
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "VideoMutedSegmentConnection",
                            "kind": "LinkedField",
                            "name": "mutedSegmentConnection",
                            "plural": false,
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "VideoMutedSegment",
                                "kind": "LinkedField",
                                "name": "nodes",
                                "plural": true,
                                "selections": [
                                  {
                                    "alias": null,
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "duration",
                                    "storageKey": null
                                  }
                                ],
                                "storageKey": null
                              }
                            ],
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "ResourceRestriction",
                        "kind": "LinkedField",
                        "name": "resourceRestriction",
                        "plural": false,
                        "selections": [
                          (v8/*: any*/),
                          (v2/*: any*/)
                        ],
                        "storageKey": null
                      },
                      (v17/*: any*/)
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": "videos(first:1,sort:\"TIME\")"
          },
          (v20/*: any*/),
          (v24/*: any*/),
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "description",
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "FollowerConnection",
            "kind": "LinkedField",
            "name": "followers",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "totalCount",
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          (v22/*: any*/),
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "profileViewCount",
            "storageKey": null
          }
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "hasTurbo",
            "storageKey": null
          },
          (v2/*: any*/),
          (v3/*: any*/),
          (v7/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v3/*: any*/),
          (v2/*: any*/),
          {
            "condition": "skipPlayToken",
            "kind": "Condition",
            "passingValue": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": (v25/*: any*/),
                "storageKey": null
              }
            ]
          }
        ],
        "storageKey": null
      },
      {
        "condition": "skipPlayToken",
        "kind": "Condition",
        "passingValue": false,
        "selections": [
          {
            "alias": null,
            "args": (v1/*: any*/),
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "user",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": [
                  (v23/*: any*/)
                ],
                "concreteType": "VideoConnection",
                "kind": "LinkedField",
                "name": "videos",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoEdge",
                    "kind": "LinkedField",
                    "name": "edges",
                    "plural": true,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "Video",
                        "kind": "LinkedField",
                        "name": "node",
                        "plural": false,
                        "selections": (v25/*: any*/),
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": "videos(first:1)"
              }
            ],
            "storageKey": null
          }
        ]
      }
    ]
  },
  "params": {
    "cacheID": "50db504aa460a4adddb93ff985db6113",
    "id": null,
    "metadata": {},
    "name": "ChannelHome_Query",
    "operationKind": "query",
    "text": "query ChannelHome_Query(\n  $login: String!\n  $platform: String!\n  $playerType: String!\n  $skipPlayToken: Boolean!\n) {\n  channel: user(login: $login) {\n    id\n    login\n    stream {\n      id\n    }\n    videoShelves {\n      edges {\n        node {\n          id\n          title\n          items {\n            __typename\n            __isVideoShelfItem: __typename\n            ... on Clip {\n              ...FocusableClipCard_clip\n            }\n            ... on Video {\n              ...FocusableVodCard_video\n            }\n          }\n        }\n      }\n    }\n    ...ProfileBanner_channel\n  }\n  currentUser {\n    ...ProfileBanner_currentUser\n    id\n    login\n    roles {\n      isStaff\n    }\n  }\n  ...StreamPlayer_token\n  ...VodPreviewPlayerWrapper_previewToken\n}\n\nfragment BannerButtonsRow_channel on User {\n  ...FocusableFollowButton_channel\n  displayName\n  hosting {\n    displayName\n    id\n    login\n    stream {\n      id\n      type\n    }\n  }\n  id\n  login\n  stream {\n    id\n    type\n  }\n  videos(first: 1, sort: TIME) {\n    edges {\n      node {\n        id\n      }\n    }\n  }\n}\n\nfragment BannerChannelStatus_channel on User {\n  displayName\n  hosting {\n    displayName\n    id\n    login\n    stream {\n      id\n      type\n    }\n  }\n  id\n  login\n  stream {\n    id\n    type\n  }\n}\n\nfragment FocusableClipCard_clip on Clip {\n  broadcaster {\n    login\n    id\n  }\n  createdAt\n  durationSeconds\n  game {\n    boxArtURL\n    displayName\n    id\n  }\n  id\n  slug\n  thumbnailURL\n  title\n  viewCount\n}\n\nfragment FocusableFollowButton_channel on User {\n  login\n  id\n  self {\n    follower {\n      followedAt\n    }\n  }\n}\n\nfragment FocusableVodCard_video on Video {\n  createdAt\n  lengthSeconds\n  game {\n    boxArtURL\n    displayName\n    id\n  }\n  id\n  previewThumbnailURL\n  self {\n    viewingHistory {\n      position\n    }\n  }\n  title\n  viewCount\n}\n\nfragment ProfileBanner_channel on User {\n  ...BannerButtonsRow_channel\n  ...BannerChannelStatus_channel\n  ...ProfilePlayer_channel\n  description\n  displayName\n  followers {\n    totalCount\n  }\n  hosting {\n    id\n    login\n    profileImageURL(width: 70)\n  }\n  id\n  login\n  profileImageURL(width: 70)\n  profileViewCount\n}\n\nfragment ProfileBanner_currentUser on User {\n  ...ProfilePlayer_currentUser\n}\n\nfragment ProfilePlayer_channel on User {\n  ...StreamPreviewPlayer_channel\n  hosting {\n    id\n    login\n    stream {\n      id\n      type\n      viewersCount\n    }\n  }\n  id\n  login\n  stream {\n    id\n    type\n    viewersCount\n  }\n  videos(first: 1, sort: TIME) {\n    edges {\n      node {\n        id\n        ...VodPreviewPlayer_video\n      }\n    }\n  }\n}\n\nfragment ProfilePlayer_currentUser on User {\n  ...StreamPreviewPlayer_currentUser\n  ...VodPreviewPlayer_currentUser\n}\n\nfragment StreamPlayer_channel on User {\n  id\n  login\n  roles {\n    isPartner\n  }\n  self {\n    subscriptionBenefit {\n      id\n    }\n  }\n  stream {\n    id\n    game {\n      name\n      id\n    }\n    previewImageURL\n  }\n}\n\nfragment StreamPlayer_currentUser on User {\n  hasTurbo\n  id\n}\n\nfragment StreamPlayer_token on Query {\n  user(login: $login) {\n    login\n    stream @skip(if: $skipPlayToken) {\n      playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {\n        signature\n        value\n      }\n      id\n    }\n    id\n  }\n}\n\nfragment StreamPreviewPlayer_channel on User {\n  hosting {\n    ...StreamPlayer_channel\n    id\n    login\n    stream {\n      id\n      type\n      viewersCount\n      previewImageURL\n    }\n  }\n  ...StreamPlayer_channel\n  id\n  login\n  stream {\n    id\n    type\n    viewersCount\n    previewImageURL\n    restrictionType\n    self {\n      canWatch\n    }\n  }\n  displayName\n  broadcastSettings {\n    isMature\n    id\n  }\n}\n\nfragment StreamPreviewPlayer_currentUser on User {\n  ...StreamPlayer_currentUser\n}\n\nfragment VodPlayerBase_currentUser on User {\n  id\n  hasTurbo\n}\n\nfragment VodPlayerBase_video on Video {\n  broadcastType\n  id\n  game {\n    name\n    id\n  }\n  owner {\n    id\n    login\n    roles {\n      isPartner\n    }\n    self {\n      subscriptionBenefit {\n        id\n      }\n    }\n  }\n  self {\n    viewingHistory {\n      position\n    }\n  }\n}\n\nfragment VodPlayerOverlay_video on Video {\n  createdAt\n  lengthSeconds\n  viewCount\n}\n\nfragment VodPreviewPlayerWrapper_previewToken on Query {\n  user(login: $login) @skip(if: $skipPlayToken) {\n    videos(first: 1) {\n      edges {\n        node {\n          playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {\n            signature\n            value\n          }\n          id\n        }\n      }\n    }\n    id\n  }\n}\n\nfragment VodPreviewPlayer_currentUser on User {\n  ...VodPlayerBase_currentUser\n}\n\nfragment VodPreviewPlayer_video on Video {\n  ...VodPlayerBase_video\n  ...VodPlayerOverlay_video\n  muteInfo {\n    mutedSegmentConnection {\n      nodes {\n        duration\n      }\n    }\n  }\n  owner {\n    id\n    login\n    broadcastSettings {\n      isMature\n      id\n    }\n    subscriptionProducts {\n      displayName\n      hasSubonlyVideoArchive\n      id\n    }\n    displayName\n  }\n  resourceRestriction {\n    type\n    id\n  }\n  self {\n    isRestricted\n  }\n  previewThumbnailURL\n}\n"
  }
};
})();
(node as any).hash = '035232dae2dd57f940503c0aa8fec9dc';
export default node;
