import type { IsolateGqlUnionType, OmitRefType } from 'tachyon-type-library';
import { reduceToNonNullNodes } from 'tachyon-utils';
import type { ChannelHome_card } from './__generated__/ChannelHome_card.graphql';
import type { ChannelHome_shelf } from './__generated__/ChannelHome_shelf.graphql';
import type { ChannelHome_shelves } from './__generated__/ChannelHome_shelves.graphql';

type Card = OmitRefType<ChannelHome_card>;
export type VodOrClipCard =
  | IsolateGqlUnionType<'Clip', ChannelHome_card>
  | IsolateGqlUnionType<'Video', ChannelHome_card>;
export type VideoShelf = OmitRefType<ChannelHome_shelf> & {
  cards: Array<VodOrClipCard>;
};
type Shelves = OmitRefType<ChannelHome_shelves>;

function validCardType(card: Card): card is VodOrClipCard {
  return ['Video', 'Clip'].includes(card.__typename);
}

export function getVideoShelves(shelves: Shelves | null): VideoShelf[] {
  return reduceToNonNullNodes(shelves?.edges)
    .map((shelf) => {
      const cards =
        shelf.items !== null
          ? shelf.items.filter(validCardType).map((card) => {
              return card;
            })
          : [];

      return {
        cards,
        id: shelf.id,
        title: shelf.title,
      };
    })
    .filter((shelf) => shelf.cards.length > 0);
}
