/* tslint:disable */
/* eslint-disable */
// @ts-nocheck

import { ConcreteRequest } from "relay-runtime";
import { FragmentRefs } from "relay-runtime";
export type ChannelInterstitial_QueryVariables = {
    login: string;
    platform: string;
    playerType: string;
    skipPlayToken: boolean;
};
export type ChannelInterstitial_QueryResponse = {
    readonly channel: {
        readonly id: string;
        readonly login: string;
        readonly displayName: string;
        readonly broadcastSettings: {
            readonly isMature: boolean;
        } | null;
        readonly stream: {
            readonly restrictionType: string | null;
            readonly self: {
                readonly canWatch: boolean;
            } | null;
            readonly id: string;
            readonly type: string | null;
        } | null;
        readonly hosting: {
            readonly displayName: string;
            readonly id: string;
            readonly login: string;
            readonly stream: {
                readonly id: string;
                readonly type: string | null;
            } | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"InterstitialLayout_channel" | "StreamDetails_channel" | "StreamPlayer_channel">;
    } | null;
    readonly currentUser: {
        readonly id: string;
        readonly login: string;
        readonly roles: {
            readonly isStaff: boolean | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"StreamPlayer_currentUser">;
    } | null;
    readonly " $fragmentRefs": FragmentRefs<"StreamPlayer_token">;
};
export type ChannelInterstitial_Query = {
    readonly response: ChannelInterstitial_QueryResponse;
    readonly variables: ChannelInterstitial_QueryVariables;
};



/*
query ChannelInterstitial_Query(
  $login: String!
  $platform: String!
  $playerType: String!
  $skipPlayToken: Boolean!
) {
  channel: user(login: $login) {
    ...InterstitialLayout_channel
    ...StreamDetails_channel
    ...StreamPlayer_channel
    id
    login
    displayName
    broadcastSettings {
      isMature
      id
    }
    stream {
      restrictionType
      self {
        canWatch
      }
      id
      type
    }
    hosting {
      displayName
      id
      login
      stream {
        id
        type
      }
    }
  }
  currentUser {
    ...StreamPlayer_currentUser
    id
    login
    roles {
      isStaff
    }
  }
  ...StreamPlayer_token
}

fragment BroadcasterOverview_channel on User {
  login
  displayName
  followers {
    totalCount
  }
  primaryColorHex
  primaryTeam {
    displayName
    id
  }
  profileImageURL(width: 70)
}

fragment ChannelDescription_channel on User {
  description
  displayName
  login
}

fragment FocusableFollowButton_channel on User {
  login
  id
  self {
    follower {
      followedAt
    }
  }
}

fragment InterstitialButtonRow_channel on User {
  ...FocusableFollowButton_channel
  login
}

fragment InterstitialLayout_channel on User {
  ...BroadcasterOverview_channel
  ...ChannelDescription_channel
  ...InterstitialButtonRow_channel
}

fragment StreamDetails_channel on User {
  broadcastSettings {
    game {
      boxArtURL
      displayName
      id
    }
    title
    id
  }
  stream {
    viewersCount
    id
  }
}

fragment StreamPlayer_channel on User {
  id
  login
  roles {
    isPartner
  }
  self {
    subscriptionBenefit {
      id
    }
  }
  stream {
    id
    game {
      name
      id
    }
    previewImageURL
  }
}

fragment StreamPlayer_currentUser on User {
  hasTurbo
  id
}

fragment StreamPlayer_token on Query {
  user(login: $login) {
    login
    stream @skip(if: $skipPlayToken) {
      playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {
        signature
        value
      }
      id
    }
    id
  }
}
*/

const node: ConcreteRequest = (function(){
var v0 = [
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "login"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "platform"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "playerType"
  },
  {
    "defaultValue": null,
    "kind": "LocalArgument",
    "name": "skipPlayToken"
  }
],
v1 = [
  {
    "kind": "Variable",
    "name": "login",
    "variableName": "login"
  }
],
v2 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "id",
  "storageKey": null
},
v3 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "login",
  "storageKey": null
},
v4 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "displayName",
  "storageKey": null
},
v5 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "isMature",
  "storageKey": null
},
v6 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "restrictionType",
  "storageKey": null
},
v7 = {
  "alias": null,
  "args": null,
  "concreteType": "StreamSelfConnection",
  "kind": "LinkedField",
  "name": "self",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "canWatch",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v8 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "type",
  "storageKey": null
},
v9 = {
  "alias": null,
  "args": null,
  "concreteType": "User",
  "kind": "LinkedField",
  "name": "hosting",
  "plural": false,
  "selections": [
    (v4/*: any*/),
    (v2/*: any*/),
    (v3/*: any*/),
    {
      "alias": null,
      "args": null,
      "concreteType": "Stream",
      "kind": "LinkedField",
      "name": "stream",
      "plural": false,
      "selections": [
        (v2/*: any*/),
        (v8/*: any*/)
      ],
      "storageKey": null
    }
  ],
  "storageKey": null
},
v10 = {
  "alias": null,
  "args": null,
  "concreteType": "UserRoles",
  "kind": "LinkedField",
  "name": "roles",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isStaff",
      "storageKey": null
    }
  ],
  "storageKey": null
};
return {
  "fragment": {
    "argumentDefinitions": (v0/*: any*/),
    "kind": "Fragment",
    "metadata": null,
    "name": "ChannelInterstitial_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          (v4/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "BroadcastSettings",
            "kind": "LinkedField",
            "name": "broadcastSettings",
            "plural": false,
            "selections": [
              (v5/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              (v6/*: any*/),
              (v7/*: any*/),
              (v2/*: any*/),
              (v8/*: any*/)
            ],
            "storageKey": null
          },
          (v9/*: any*/),
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "InterstitialLayout_channel"
          },
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "StreamDetails_channel"
          },
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "StreamPlayer_channel"
          }
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          (v2/*: any*/),
          (v3/*: any*/),
          (v10/*: any*/),
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "StreamPlayer_currentUser"
          }
        ],
        "storageKey": null
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "StreamPlayer_token"
      }
    ],
    "type": "Query",
    "abstractKey": null
  },
  "kind": "Request",
  "operation": {
    "argumentDefinitions": (v0/*: any*/),
    "kind": "Operation",
    "name": "ChannelInterstitial_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v3/*: any*/),
          (v4/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "FollowerConnection",
            "kind": "LinkedField",
            "name": "followers",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "totalCount",
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "primaryColorHex",
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "Team",
            "kind": "LinkedField",
            "name": "primaryTeam",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v2/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": [
              {
                "kind": "Literal",
                "name": "width",
                "value": 70
              }
            ],
            "kind": "ScalarField",
            "name": "profileImageURL",
            "storageKey": "profileImageURL(width:70)"
          },
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "description",
            "storageKey": null
          },
          (v2/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "UserSelfConnection",
            "kind": "LinkedField",
            "name": "self",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "FollowerEdge",
                "kind": "LinkedField",
                "name": "follower",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "followedAt",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "SubscriptionBenefit",
                "kind": "LinkedField",
                "name": "subscriptionBenefit",
                "plural": false,
                "selections": [
                  (v2/*: any*/)
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "BroadcastSettings",
            "kind": "LinkedField",
            "name": "broadcastSettings",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "Game",
                "kind": "LinkedField",
                "name": "game",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "boxArtURL",
                    "storageKey": null
                  },
                  (v4/*: any*/),
                  (v2/*: any*/)
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "title",
                "storageKey": null
              },
              (v2/*: any*/),
              (v5/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "viewersCount",
                "storageKey": null
              },
              (v2/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Game",
                "kind": "LinkedField",
                "name": "game",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "name",
                    "storageKey": null
                  },
                  (v2/*: any*/)
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "previewImageURL",
                "storageKey": null
              },
              (v6/*: any*/),
              (v7/*: any*/),
              (v8/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "UserRoles",
            "kind": "LinkedField",
            "name": "roles",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "isPartner",
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          (v9/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "hasTurbo",
            "storageKey": null
          },
          (v2/*: any*/),
          (v3/*: any*/),
          (v10/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": (v1/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v3/*: any*/),
          (v2/*: any*/),
          {
            "condition": "skipPlayToken",
            "kind": "Condition",
            "passingValue": false,
            "selections": [
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": [
                      {
                        "fields": [
                          {
                            "kind": "Variable",
                            "name": "platform",
                            "variableName": "platform"
                          },
                          {
                            "kind": "Variable",
                            "name": "playerType",
                            "variableName": "playerType"
                          }
                        ],
                        "kind": "ObjectValue",
                        "name": "params"
                      }
                    ],
                    "concreteType": "PlaybackAccessToken",
                    "kind": "LinkedField",
                    "name": "playbackAccessToken",
                    "plural": false,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "signature",
                        "storageKey": null
                      },
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "value",
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  },
                  (v2/*: any*/)
                ],
                "storageKey": null
              }
            ]
          }
        ],
        "storageKey": null
      }
    ]
  },
  "params": {
    "cacheID": "c035c9049e1198256fe335d418cb029d",
    "id": null,
    "metadata": {},
    "name": "ChannelInterstitial_Query",
    "operationKind": "query",
    "text": "query ChannelInterstitial_Query(\n  $login: String!\n  $platform: String!\n  $playerType: String!\n  $skipPlayToken: Boolean!\n) {\n  channel: user(login: $login) {\n    ...InterstitialLayout_channel\n    ...StreamDetails_channel\n    ...StreamPlayer_channel\n    id\n    login\n    displayName\n    broadcastSettings {\n      isMature\n      id\n    }\n    stream {\n      restrictionType\n      self {\n        canWatch\n      }\n      id\n      type\n    }\n    hosting {\n      displayName\n      id\n      login\n      stream {\n        id\n        type\n      }\n    }\n  }\n  currentUser {\n    ...StreamPlayer_currentUser\n    id\n    login\n    roles {\n      isStaff\n    }\n  }\n  ...StreamPlayer_token\n}\n\nfragment BroadcasterOverview_channel on User {\n  login\n  displayName\n  followers {\n    totalCount\n  }\n  primaryColorHex\n  primaryTeam {\n    displayName\n    id\n  }\n  profileImageURL(width: 70)\n}\n\nfragment ChannelDescription_channel on User {\n  description\n  displayName\n  login\n}\n\nfragment FocusableFollowButton_channel on User {\n  login\n  id\n  self {\n    follower {\n      followedAt\n    }\n  }\n}\n\nfragment InterstitialButtonRow_channel on User {\n  ...FocusableFollowButton_channel\n  login\n}\n\nfragment InterstitialLayout_channel on User {\n  ...BroadcasterOverview_channel\n  ...ChannelDescription_channel\n  ...InterstitialButtonRow_channel\n}\n\nfragment StreamDetails_channel on User {\n  broadcastSettings {\n    game {\n      boxArtURL\n      displayName\n      id\n    }\n    title\n    id\n  }\n  stream {\n    viewersCount\n    id\n  }\n}\n\nfragment StreamPlayer_channel on User {\n  id\n  login\n  roles {\n    isPartner\n  }\n  self {\n    subscriptionBenefit {\n      id\n    }\n  }\n  stream {\n    id\n    game {\n      name\n      id\n    }\n    previewImageURL\n  }\n}\n\nfragment StreamPlayer_currentUser on User {\n  hasTurbo\n  id\n}\n\nfragment StreamPlayer_token on Query {\n  user(login: $login) {\n    login\n    stream @skip(if: $skipPlayToken) {\n      playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {\n        signature\n        value\n      }\n      id\n    }\n    id\n  }\n}\n"
  }
};
})();
(node as any).hash = 'd9b5e36d5eb24e2993c230c011ecd4ff';
export default node;
