import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../../routing';
import { FocusableIconButton } from '../../../../../common';

type ClipSettingsButtonProps = {
  focusIndex: number;
  login: string;
};

// istanbul ignore next: trivial
export const ClipSettingsButton: FC<ClipSettingsButtonProps> = ({
  focusIndex,
  login,
}) => {
  const { formatMessage } = useIntl();

  return (
    <FocusableIconButton
      aria-label={formatMessage('Clip Settings', 'BottomControls')}
      focusIndex={focusIndex}
      icon={SVGAsset.NavMore}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.SettingsChannel,
        routeParams: { login },
      })}
    />
  );
};

ClipSettingsButton.displayName = 'ClipSettingsButton';
