import { createMountWrapperFactory } from 'tachyon-test-utils';
import { PlayPauseButton, PlaybackScrubBar } from '../../../player';
import type { ClipPlayingUIProps } from '.';
import { ClipPlayingUIBase } from '.';

jest.mock('../../../player', () => ({
  ClipPlayer: () => <div />,
  HideablePlayPauseButton: () => <div />,
  MediaSession: () => null,
  PlayPauseButton: () => <div />,
  PlaybackScrubBar: () => <div />,
  ScrubControlsRoot: () => <div />,
}));

jest.mock('./ClipBottomControls', () => ({
  ClipBottomControls: () => <div />,
}));

const mockClip = ({ durationSeconds = 40 }): ClipPlayingUIProps => ({
  clip: {
    ' $fragmentRefs': {
      ClipBottomControls_clip: true,
      ClipPlayer_clip: true,
    },
    ' $refType': 'ClipPlayingUI_clip',
    broadcaster: {
      displayName: 'therealderekt',
      login: 'therealderekt',
      roles: {
        isAffiliate: false,
        isPartner: true,
      },
    },
    durationSeconds,
  },
  clipToken: {
    ' $fragmentRefs': { ClipPlayer_token: true },
  },
  currentUser: null,
  focusIndex: 0,
});

describe(ClipPlayingUIBase, () => {
  const setup = createMountWrapperFactory(ClipPlayingUIBase, () =>
    mockClip({}),
  );

  it('it displays the scrub bar on clips longer than 30 seconds', () => {
    const { wrapper } = setup();
    expect(wrapper.find(PlayPauseButton)).not.toExist();
    expect(wrapper.find(PlaybackScrubBar)).toExist();
  });

  it('it does not display the scrub bar on clips shorter than 30 seconds', () => {
    const { wrapper } = setup(mockClip({ durationSeconds: 15 }));
    expect(wrapper.find(PlayPauseButton)).toExist();
    expect(wrapper.find(PlaybackScrubBar)).not.toExist();
  });
});
