import { datatype, lorem } from 'faker';
import { Platform, useStaticEnvironment } from 'tachyon-environment';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Redirect, RouteName } from '../../../routing';
import { NotFoundError } from '../../errors';
import { ClipPlayingUI } from './ClipPlayingUI';
import { Clip } from '.';

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));

const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;

describe(Clip, () => {
  mockUseStaticEnvironment.mockReturnValue({
    common: { platform: Platform.StarshotDev },
  });
  const setup = createShallowWrapperFactory(Clip, () => ({
    ' $fragmentRefs': { ClipPlayer_token: true },
    clip: {
      ' $fragmentRefs': {
        ClipPlayingUI_clip: true,
      },
      broadcaster: {
        broadcastSettings: {
          isMature: false,
        },
        id: datatype.uuid(),
        login: 'therealderekt',
      },
      game: {
        name: lorem.words(5),
      },
      id: datatype.uuid(),
      slug: 'RambunctiousMeddlingKappaStealer',
    },
    currentUser: null,
    queryVariables: {
      platform: Platform.StarshotDev,
      playerType: 'pulsar',
      skipPlayToken: true,
      slug: 'RambunctiousMeddlingKappaStealer',
    },
  }));

  it('redirects to the interstitial when the platform is switch', () => {
    mockUseStaticEnvironment.mockReturnValueOnce({
      common: { platform: Platform.Switch },
    });
    const { wrapper } = setup({
      clip: {
        broadcaster: {
          login: 'bar',
        },
        slug: 'foo',
      },
      queryVariables: { slug: 'foo' },
    });

    expect(wrapper.find(Redirect)).toHaveProp({
      params: {
        route: RouteName.ClipInterstitial,
        routeParams: { login: 'bar', slug: 'foo' },
      },
      replace: true,
    });
  });

  it('renders the not found UX when Clip is not found', () => {
    const { wrapper } = setup({ clip: null });
    expect(wrapper.find(NotFoundError)).toExist();
    expect(wrapper.find(ClipPlayingUI)).not.toExist();
  });

  it('does not render the not found UX when Clip is found', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ClipPlayingUI)).toExist();
    expect(wrapper.find(NotFoundError)).not.toExist();
  });
});
