/* tslint:disable */
/* eslint-disable */
// @ts-nocheck

import { ConcreteRequest } from "relay-runtime";
import { FragmentRefs } from "relay-runtime";
export type ClipInterstitial_QueryVariables = {
    slug: string;
    platform: string;
    playerType: string;
    skipPlayToken: boolean;
};
export type ClipInterstitial_QueryResponse = {
    readonly clip: {
        readonly broadcaster: {
            readonly id: string;
            readonly broadcastSettings: {
                readonly isMature: boolean;
            } | null;
            readonly login: string;
            readonly hosting: {
                readonly id: string;
            } | null;
            readonly stream: {
                readonly id: string;
                readonly type: string | null;
            } | null;
            readonly " $fragmentRefs": FragmentRefs<"InterstitialLayout_channel">;
        } | null;
        readonly id: string;
        readonly createdAt: string;
        readonly durationSeconds: number;
        readonly game: {
            readonly boxArtURL: string | null;
            readonly displayName: string;
            readonly name: string;
        } | null;
        readonly slug: string;
        readonly title: string;
        readonly video: {
            readonly id: string;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ClipPlayer_clip">;
    } | null;
    readonly currentUser: {
        readonly id: string;
        readonly login: string;
        readonly roles: {
            readonly isStaff: boolean | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ClipPlayer_currentUser">;
    } | null;
    readonly " $fragmentRefs": FragmentRefs<"ClipPlayer_token">;
};
export type ClipInterstitial_Query = {
    readonly response: ClipInterstitial_QueryResponse;
    readonly variables: ClipInterstitial_QueryVariables;
};



/*
query ClipInterstitial_Query(
  $slug: ID!
  $platform: String!
  $playerType: String!
  $skipPlayToken: Boolean!
) {
  clip(slug: $slug) {
    ...ClipPlayer_clip
    broadcaster {
      id
      broadcastSettings {
        isMature
        id
      }
      ...InterstitialLayout_channel
      login
      hosting {
        id
      }
      stream {
        id
        type
      }
    }
    id
    createdAt
    durationSeconds
    game {
      boxArtURL
      displayName
      name
      id
    }
    slug
    title
    video {
      id
    }
  }
  currentUser {
    id
    login
    roles {
      isStaff
    }
    ...ClipPlayer_currentUser
  }
  ...ClipPlayer_token
}

fragment BroadcasterOverview_channel on User {
  login
  displayName
  followers {
    totalCount
  }
  primaryColorHex
  primaryTeam {
    displayName
    id
  }
  profileImageURL(width: 70)
}

fragment ChannelDescription_channel on User {
  description
  displayName
  login
}

fragment ClipPlayer_clip on Clip {
  id
  game {
    name
    id
  }
  broadcaster {
    id
    login
    roles {
      isPartner
    }
    self {
      subscriptionBenefit {
        id
      }
    }
  }
  slug
}

fragment ClipPlayer_currentUser on User {
  id
  hasTurbo
}

fragment ClipPlayer_token on Query {
  clip(slug: $slug) @skip(if: $skipPlayToken) {
    playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {
      signature
      value
    }
    videoQualities {
      frameRate
      quality
      sourceURL
    }
    id
  }
}

fragment FocusableFollowButton_channel on User {
  login
  id
  self {
    follower {
      followedAt
    }
  }
}

fragment InterstitialButtonRow_channel on User {
  ...FocusableFollowButton_channel
  login
}

fragment InterstitialLayout_channel on User {
  ...BroadcasterOverview_channel
  ...ChannelDescription_channel
  ...InterstitialButtonRow_channel
}
*/

const node: ConcreteRequest = (function(){
var v0 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "platform"
},
v1 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "playerType"
},
v2 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "skipPlayToken"
},
v3 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "slug"
},
v4 = [
  {
    "kind": "Variable",
    "name": "slug",
    "variableName": "slug"
  }
],
v5 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "id",
  "storageKey": null
},
v6 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "isMature",
  "storageKey": null
},
v7 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "login",
  "storageKey": null
},
v8 = [
  (v5/*: any*/)
],
v9 = {
  "alias": null,
  "args": null,
  "concreteType": "User",
  "kind": "LinkedField",
  "name": "hosting",
  "plural": false,
  "selections": (v8/*: any*/),
  "storageKey": null
},
v10 = {
  "alias": null,
  "args": null,
  "concreteType": "Stream",
  "kind": "LinkedField",
  "name": "stream",
  "plural": false,
  "selections": [
    (v5/*: any*/),
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "type",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v11 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "createdAt",
  "storageKey": null
},
v12 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "durationSeconds",
  "storageKey": null
},
v13 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "boxArtURL",
  "storageKey": null
},
v14 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "displayName",
  "storageKey": null
},
v15 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "name",
  "storageKey": null
},
v16 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "slug",
  "storageKey": null
},
v17 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "title",
  "storageKey": null
},
v18 = {
  "alias": null,
  "args": null,
  "concreteType": "Video",
  "kind": "LinkedField",
  "name": "video",
  "plural": false,
  "selections": (v8/*: any*/),
  "storageKey": null
},
v19 = {
  "alias": null,
  "args": null,
  "concreteType": "UserRoles",
  "kind": "LinkedField",
  "name": "roles",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isStaff",
      "storageKey": null
    }
  ],
  "storageKey": null
};
return {
  "fragment": {
    "argumentDefinitions": [
      (v0/*: any*/),
      (v1/*: any*/),
      (v2/*: any*/),
      (v3/*: any*/)
    ],
    "kind": "Fragment",
    "metadata": null,
    "name": "ClipInterstitial_Query",
    "selections": [
      {
        "alias": null,
        "args": (v4/*: any*/),
        "concreteType": "Clip",
        "kind": "LinkedField",
        "name": "clip",
        "plural": false,
        "selections": [
          {
            "alias": null,
            "args": null,
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "broadcaster",
            "plural": false,
            "selections": [
              (v5/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "BroadcastSettings",
                "kind": "LinkedField",
                "name": "broadcastSettings",
                "plural": false,
                "selections": [
                  (v6/*: any*/)
                ],
                "storageKey": null
              },
              (v7/*: any*/),
              (v9/*: any*/),
              (v10/*: any*/),
              {
                "args": null,
                "kind": "FragmentSpread",
                "name": "InterstitialLayout_channel"
              }
            ],
            "storageKey": null
          },
          (v5/*: any*/),
          (v11/*: any*/),
          (v12/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "Game",
            "kind": "LinkedField",
            "name": "game",
            "plural": false,
            "selections": [
              (v13/*: any*/),
              (v14/*: any*/),
              (v15/*: any*/)
            ],
            "storageKey": null
          },
          (v16/*: any*/),
          (v17/*: any*/),
          (v18/*: any*/),
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "ClipPlayer_clip"
          }
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          (v5/*: any*/),
          (v7/*: any*/),
          (v19/*: any*/),
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "ClipPlayer_currentUser"
          }
        ],
        "storageKey": null
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "ClipPlayer_token"
      }
    ],
    "type": "Query",
    "abstractKey": null
  },
  "kind": "Request",
  "operation": {
    "argumentDefinitions": [
      (v3/*: any*/),
      (v0/*: any*/),
      (v1/*: any*/),
      (v2/*: any*/)
    ],
    "kind": "Operation",
    "name": "ClipInterstitial_Query",
    "selections": [
      {
        "alias": null,
        "args": (v4/*: any*/),
        "concreteType": "Clip",
        "kind": "LinkedField",
        "name": "clip",
        "plural": false,
        "selections": [
          (v5/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "Game",
            "kind": "LinkedField",
            "name": "game",
            "plural": false,
            "selections": [
              (v15/*: any*/),
              (v5/*: any*/),
              (v13/*: any*/),
              (v14/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "broadcaster",
            "plural": false,
            "selections": [
              (v5/*: any*/),
              (v7/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "UserRoles",
                "kind": "LinkedField",
                "name": "roles",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "isPartner",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "UserSelfConnection",
                "kind": "LinkedField",
                "name": "self",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "SubscriptionBenefit",
                    "kind": "LinkedField",
                    "name": "subscriptionBenefit",
                    "plural": false,
                    "selections": (v8/*: any*/),
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "FollowerEdge",
                    "kind": "LinkedField",
                    "name": "follower",
                    "plural": false,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "kind": "ScalarField",
                        "name": "followedAt",
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "BroadcastSettings",
                "kind": "LinkedField",
                "name": "broadcastSettings",
                "plural": false,
                "selections": [
                  (v6/*: any*/),
                  (v5/*: any*/)
                ],
                "storageKey": null
              },
              (v14/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "FollowerConnection",
                "kind": "LinkedField",
                "name": "followers",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "totalCount",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "primaryColorHex",
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "Team",
                "kind": "LinkedField",
                "name": "primaryTeam",
                "plural": false,
                "selections": [
                  (v14/*: any*/),
                  (v5/*: any*/)
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": [
                  {
                    "kind": "Literal",
                    "name": "width",
                    "value": 70
                  }
                ],
                "kind": "ScalarField",
                "name": "profileImageURL",
                "storageKey": "profileImageURL(width:70)"
              },
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "description",
                "storageKey": null
              },
              (v9/*: any*/),
              (v10/*: any*/)
            ],
            "storageKey": null
          },
          (v16/*: any*/),
          (v11/*: any*/),
          (v12/*: any*/),
          (v17/*: any*/),
          (v18/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": null,
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "currentUser",
        "plural": false,
        "selections": [
          (v5/*: any*/),
          (v7/*: any*/),
          (v19/*: any*/),
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "hasTurbo",
            "storageKey": null
          }
        ],
        "storageKey": null
      },
      {
        "condition": "skipPlayToken",
        "kind": "Condition",
        "passingValue": false,
        "selections": [
          {
            "alias": null,
            "args": (v4/*: any*/),
            "concreteType": "Clip",
            "kind": "LinkedField",
            "name": "clip",
            "plural": false,
            "selections": [
              {
                "alias": null,
                "args": [
                  {
                    "fields": [
                      {
                        "kind": "Variable",
                        "name": "platform",
                        "variableName": "platform"
                      },
                      {
                        "kind": "Variable",
                        "name": "playerType",
                        "variableName": "playerType"
                      }
                    ],
                    "kind": "ObjectValue",
                    "name": "params"
                  }
                ],
                "concreteType": "PlaybackAccessToken",
                "kind": "LinkedField",
                "name": "playbackAccessToken",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "signature",
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "value",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "ClipVideoQuality",
                "kind": "LinkedField",
                "name": "videoQualities",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "frameRate",
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "quality",
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "sourceURL",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          }
        ]
      }
    ]
  },
  "params": {
    "cacheID": "67ca5d8c4938f2176de31c818ebf1012",
    "id": null,
    "metadata": {},
    "name": "ClipInterstitial_Query",
    "operationKind": "query",
    "text": "query ClipInterstitial_Query(\n  $slug: ID!\n  $platform: String!\n  $playerType: String!\n  $skipPlayToken: Boolean!\n) {\n  clip(slug: $slug) {\n    ...ClipPlayer_clip\n    broadcaster {\n      id\n      broadcastSettings {\n        isMature\n        id\n      }\n      ...InterstitialLayout_channel\n      login\n      hosting {\n        id\n      }\n      stream {\n        id\n        type\n      }\n    }\n    id\n    createdAt\n    durationSeconds\n    game {\n      boxArtURL\n      displayName\n      name\n      id\n    }\n    slug\n    title\n    video {\n      id\n    }\n  }\n  currentUser {\n    id\n    login\n    roles {\n      isStaff\n    }\n    ...ClipPlayer_currentUser\n  }\n  ...ClipPlayer_token\n}\n\nfragment BroadcasterOverview_channel on User {\n  login\n  displayName\n  followers {\n    totalCount\n  }\n  primaryColorHex\n  primaryTeam {\n    displayName\n    id\n  }\n  profileImageURL(width: 70)\n}\n\nfragment ChannelDescription_channel on User {\n  description\n  displayName\n  login\n}\n\nfragment ClipPlayer_clip on Clip {\n  id\n  game {\n    name\n    id\n  }\n  broadcaster {\n    id\n    login\n    roles {\n      isPartner\n    }\n    self {\n      subscriptionBenefit {\n        id\n      }\n    }\n  }\n  slug\n}\n\nfragment ClipPlayer_currentUser on User {\n  id\n  hasTurbo\n}\n\nfragment ClipPlayer_token on Query {\n  clip(slug: $slug) @skip(if: $skipPlayToken) {\n    playbackAccessToken(params: {platform: $platform, playerType: $playerType}) {\n      signature\n      value\n    }\n    videoQualities {\n      frameRate\n      quality\n      sourceURL\n    }\n    id\n  }\n}\n\nfragment FocusableFollowButton_channel on User {\n  login\n  id\n  self {\n    follower {\n      followedAt\n    }\n  }\n}\n\nfragment InterstitialButtonRow_channel on User {\n  ...FocusableFollowButton_channel\n  login\n}\n\nfragment InterstitialLayout_channel on User {\n  ...BroadcasterOverview_channel\n  ...ChannelDescription_channel\n  ...InterstitialButtonRow_channel\n}\n"
  }
};
})();
(node as any).hash = 'fed623daa202a303540a4c50018f5b99';
export default node;
