import { datatype, date, image, lorem } from 'faker';
import { Platform, useStaticEnvironment } from 'tachyon-environment';
import { StreamType } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Redirect } from '../../../routing';
import { NotFoundError } from '../../errors';
import type { ClipInterstitialProps } from '.';
import { ClipInterstitial } from '.';

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));

const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;

const mockProps: ClipInterstitialProps = {
  ' $fragmentRefs': { ClipPlayer_token: true },
  clip: {
    ' $fragmentRefs': {
      ClipPlayer_clip: true,
    },
    broadcaster: {
      ' $fragmentRefs': {
        InterstitialLayout_channel: true,
      },
      broadcastSettings: {
        isMature: false,
      },
      hosting: {
        id: datatype.uuid(),
      },
      id: datatype.uuid(),
      login: 'therealderekt',
      stream: {
        id: datatype.uuid(),
        type: StreamType.Live,
      },
    },
    createdAt: date.past().toISOString(),
    durationSeconds: datatype.number({ max: 30, min: 3 }),
    game: {
      boxArtURL: image.imageUrl(),
      displayName: lorem.words(5),
      name: lorem.words(5),
    },
    id: datatype.uuid(),
    slug: 'RambunctiousMeddlingKappaStealer',
    title: lorem.words(5),
    video: {
      id: datatype.uuid(),
    },
  },
  currentUser: null,
  queryVariables: {
    platform: Platform.StarshotDev,
    playerType: 'pulsar',
    skipPlayToken: true,
    slug: 'RambunctiousMeddlingKappaStealer',
  },
};

describe(ClipInterstitial, () => {
  const setup = createShallowWrapperFactory(ClipInterstitial, () => mockProps);

  beforeEach(() => {
    mockUseStaticEnvironment.mockReturnValue({
      common: { platform: Platform.Switch },
    });
  });

  it('renders the not found UX when Clip is not found', () => {
    const { wrapper } = setup({ clip: null });
    expect(wrapper.find(NotFoundError)).toExist();
  });

  it('does not render the not found UX when Clip is found', () => {
    const { wrapper } = setup();
    expect(wrapper.find(NotFoundError)).not.toExist();
  });

  it('redirects to the Clip page if platform is not Switch', () => {
    mockUseStaticEnvironment.mockImplementationOnce(() => ({
      common: { platform: Platform.LG },
    }));

    const { wrapper } = setup();
    expect(wrapper.find(Redirect)).toExist();
  });
});
