import type { FC } from 'react';
import { useCurrentUser } from 'tachyon-auth';
import { useIntl } from 'tachyon-intl';
import type { OmitRefType } from 'tachyon-type-library';
import { getGameDisplayName } from 'tachyon-utils';
import { CoreText, FontSize, Layout } from 'twitch-core-ui';
import {
  RouteName,
  createRedirectQuery,
  renderTachyonLink,
} from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import type { GameDirectory_game } from '../../__generated__/GameDirectory_game.graphql';

export type GameDirectoryGame = OmitRefType<GameDirectory_game>;

type GameDirectoryBannerContent = {
  // game directory banner content does not update in response to navigation
  data: undefined;
  game: GameDirectoryGame;
};

export const GameDirectoryBannerContent: FC<GameDirectoryBannerContent> = ({
  game,
}) => {
  const { formatMessage } = useIntl();
  const { loggedIn } = useCurrentUser();
  return (
    <>
      <CoreText fontSize={FontSize.Size2} role="heading">
        {getGameDisplayName(game)}
      </CoreText>
      <Layout margin={{ top: 1 }}>
        <FocusableTextButton
          focusIndex={0}
          linkTo="/deferToRenderLink"
          renderLink={
            loggedIn
              ? renderTachyonLink({
                  route: RouteName.SettingsGameNotInterested,
                  routeParams: {
                    gameAlias: game.name,
                  },
                })
              : renderTachyonLink({
                  query: createRedirectQuery({
                    route: RouteName.SettingsGameNotInterested,
                    routeParams: {
                      gameAlias: game.name,
                    },
                  }),
                  route: RouteName.Login,
                })
          }
          withUnfocusBackground
        >
          {formatMessage('Not Interested', 'GameInfo')}
        </FocusableTextButton>
      </Layout>
    </>
  );
};

GameDirectoryBannerContent.displayName = 'GameDirectoryBannerContent';
