import { internet } from 'faker';
import { useCurrentUser } from 'tachyon-auth';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import {
  RouteName,
  createRedirectQuery,
  renderTachyonLink,
} from '../../../../../routing';
import type { GameDirectoryGame, GameDirectoryStreamList } from '../index';
import { GameDirectoryBannerContent } from '.';

jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: jest.fn(() => ({ loggedIn: false })),
}));

jest.mock('../../../../../routing', () => ({
  ...jest.requireActual('../../../../../routing'),
  renderTachyonLink: jest.fn(() => () => <div />),
}));

jest.mock('../../../../common', () => ({
  ...jest.requireActual('../../../../common'),
  useBannerData: jest.fn(),
}));

const mockUseCurrentUser = useCurrentUser as jest.Mock;
const mockRenderTachyonLink = renderTachyonLink as jest.Mock;

const mockStreamListFragment: GameDirectoryStreamList = [
  {
    ' $fragmentRefs': {
      FocusableStreamCard_stream: true,
    },
    id: validId(),
    previewImageURL: internet.url(),
  },

  {
    ' $fragmentRefs': {
      FocusableStreamCard_stream: true,
    },
    id: validId(),
    previewImageURL: internet.url(),
  },
];

const mockGameFragment: GameDirectoryGame = {
  boxArtURL: internet.url(),
  displayName: 'Fornite',
  name: 'Fornite',
  streams: mockStreamListFragment as any,
};

describe(GameDirectoryBannerContent, () => {
  const setup = createShallowWrapperFactory(GameDirectoryBannerContent, () => ({
    data: undefined,
    game: mockGameFragment,
  }));

  describe('not interested button', () => {
    it('links to not interested settings page when logged in', () => {
      mockUseCurrentUser.mockImplementationOnce(() => ({
        loggedIn: true,
      }));

      const { props } = setup();

      expect(mockRenderTachyonLink).toHaveBeenCalledWith({
        route: RouteName.SettingsGameNotInterested,
        routeParams: {
          gameAlias: props.game.name,
        },
      });
    });

    it('links to login page when not logged in', () => {
      mockUseCurrentUser.mockImplementationOnce(() => ({
        loggedIn: false,
      }));

      const { props } = setup();

      expect(mockRenderTachyonLink).toHaveBeenCalledWith({
        query: createRedirectQuery({
          route: RouteName.SettingsGameNotInterested,
          routeParams: {
            gameAlias: props.game.name,
          },
        }),
        route: RouteName.Login,
      });
    });
  });
});
