import { internet } from 'faker';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { FocusableTower, useBannerData } from '../../../common';
import type { GameDirectoryGame, GameDirectoryStreamList } from '.';
import { GameDirectoryContent } from '.';

jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: jest.fn(() => ({ loggedIn: false })),
}));

jest.mock('../../../../routing', () => ({
  ...jest.requireActual('../../../../routing'),
  renderTachyonLink: jest.fn(() => () => <div />),
}));

jest.mock('../../../common', () => ({
  ...jest.requireActual('../../../common'),
  useBannerData: jest.fn(),
}));
const mockUseBannerData = useBannerData as jest.Mock;

const mockStreamListFragment: GameDirectoryStreamList = [
  {
    ' $fragmentRefs': {
      FocusableStreamCard_stream: true,
    },
    id: validId(),
    previewImageURL: internet.url(),
  },

  {
    ' $fragmentRefs': {
      FocusableStreamCard_stream: true,
    },
    id: validId(),
    previewImageURL: internet.url(),
  },
];

const mockGameFragment: GameDirectoryGame = {
  boxArtURL: internet.url(),
  displayName: 'Fornite',
  name: 'Fornite',
  streams: mockStreamListFragment as any,
};

describe(GameDirectoryContent, () => {
  const setup = createShallowWrapperFactory(GameDirectoryContent, () => ({
    focusIndex: 0,
    game: mockGameFragment,
    streams: mockStreamListFragment,
  }));

  it('sets the initial background image', () => {
    const { props } = setup();

    expect(mockUseBannerData).toHaveBeenCalledWith({
      backgroundImageSrc: props.streams[0].previewImageURL,
      categoryImageSrc: props.game.boxArtURL,
    });
  });

  it('provides the streams to the tower', () => {
    const { props, wrapper } = setup();

    expect(wrapper.find(FocusableTower).prop('items')).toHaveLength(
      props.streams.length,
    );
  });
});
