import { lorem } from 'faker';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import type { GameDirectoryGame } from './GameDirectoryContent';
import { GameDirectory, REQUESTED_STREAM_COUNT } from '.';

jest.mock('../../common/FocusableStreamCard', () => ({
  FocusableStreamCard: jest.fn(() => <div />),
}));

const mockGameFragment: GameDirectoryGame = {
  boxArtURL: 'foo',
  displayName: 'Fornite',
  name: 'Fornite',
  streams: {
    edges: [
      {
        node: {
          ' $fragmentRefs': {
            FocusableStreamCard_stream: true,
          },
          id: validId(),
          previewImageURL: null,
        },
      },
      {
        node: {
          ' $fragmentRefs': {
            FocusableStreamCard_stream: true,
          },
          id: validId(),
          previewImageURL: null,
        },
      },
    ],
  },
};
describe(GameDirectory, () => {
  describe(GameDirectory.getInitialProps!, () => {
    it('extracts gameAlias and sets channelsCount', async () => {
      const gameAlias = 'Halo%20Infinite';

      const res = await GameDirectory.getInitialProps!({
        query: {
          gameAlias,
        },
      } as any);

      expect(res).toEqual({
        queryVariables: {
          channelsCount: REQUESTED_STREAM_COUNT,
          gameAlias: gameAlias.toLowerCase(),
        },
      });
    });
  });

  describe('render', () => {
    const setup = createShallowWrapperFactory(GameDirectory, () => ({
      currentUser: null,
      game: { ...mockGameFragment },
      queryVariables: {
        channelsCount: REQUESTED_STREAM_COUNT,
        gameAlias: lorem.word(),
      },
    }));

    it('renders the no live channels message when game is null', () => {
      const { wrapper } = setup({
        game: null,
      });

      expect(wrapper.debug()).toContain('There are no live channels');
    });
  });
});
