import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import type { StarshotPage } from '../types';

/**
 * Health check page renderer.
 *
 * This just renders an okay message if it succeeds. If it fails then the
 * health check would fail and this instance of starshot would stop receiving
 * traffic.
 */
export const HealthCheck: StarshotPage = () => {
  // The rendered content doesn't actually matter, health checks should
  // only be using the status code. If we have a more complicated system
  // later we may want to make this into a table of status checks so that a
  // human looking at it could see why we got an unexpected status code.
  return <>ok</>;
};

HealthCheck.currentUser = getCurrentUser;
HealthCheck.displayName = 'HealthCheck';
HealthCheck.navigationBehavior = () => ({
  noFocusableContent: true,
});
HealthCheck.pageviewTracking = defaultPageviewTracking;

/**
 * If run on server will reach into context to set a no-store cache header.
 *
 * Returns an empty object since HealthCheck requires no context.
 */
HealthCheck.getInitialProps = ({ res }) => {
  if (res) {
    // Do not store the request or response in non-volatile memory.
    // See section 5.2.1.5 https://tools.ietf.org/html/rfc7234#section-5.2
    res.setHeader('Cache-Control', 'no-store');

    // Enable CORS so laser-array can query the health of Starshot's cluster.
    // More context: https://jira.twitch.com/browse/MWC-2414
    res.setHeader('Access-Control-Allow-Origin', '*');
  }

  return {};
};
