import { createShallowWrapperFactory } from 'tachyon-test-utils';
import type { StarshotPageContext } from '../types';
import { HealthCheck } from '.';

describe(HealthCheck, () => {
  const setup = createShallowWrapperFactory(HealthCheck);

  describe('server-side cache handling', () => {
    it('sets the cache header not to store anything', () => {
      const context = { res: { setHeader: jest.fn() } };
      HealthCheck.getInitialProps!(context as unknown as StarshotPageContext);
      expect(context.res.setHeader).toHaveBeenCalledWith(
        'Cache-Control',
        'no-store',
      );
    });
  });

  describe('client-side cache handling', () => {
    it('does not throw in getInitialProps', () => {
      const context = {};
      expect(() =>
        HealthCheck.getInitialProps!(context as unknown as StarshotPageContext),
      ).not.toThrow();
    });
  });

  describe('rendering', () => {
    it('renders something', () => {
      expect(setup().wrapper).not.toBeEmptyRender();
    });
  });
});
