import type { FC } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import type { OmitRefType } from 'tachyon-type-library';
import { Color, CoreText, TextType } from 'twitch-core-ui';
import type { Homepage_stream } from '../__generated__/Homepage_stream.graphql';

/* stylelint-disable property-no-vendor-prefix,value-no-vendor-prefix */
const ScStreamTitle = styled.div`
  -webkit-box-orient: vertical;
  display: -webkit-box;
  height: 5.6rem;
  -webkit-line-clamp: 2;
  max-width: 35vw;
  overflow: hidden;

  @supports not (-webkit-line-clamp: 2) {
    display: block;
    text-overflow: ellipsis;
    white-space: nowrap;
  }
`;

export type HomepageBannerContentProps = {
  data: OmitRefType<Homepage_stream> | null;
};

export const HomepageBannerContent: FC<HomepageBannerContentProps> = ({
  data,
}) => {
  const { formatMessage } = useIntl();
  const broadcasterName = data?.broadcaster?.displayName;
  const categoryName = data?.game?.displayName;
  const title = data?.broadcaster?.broadcastSettings?.title;
  return (
    <>
      <CoreText color={Color.Live} type={TextType.H5}>
        {formatMessage('LIVE NOW', 'Homepage')}
      </CoreText>
      {broadcasterName && categoryName && (
        <CoreText type={TextType.H5}>
          {formatMessage(
            '{broadcasterName} playing {categoryName}',
            { broadcasterName, categoryName },
            'Homepage',
          )}
        </CoreText>
      )}
      {title && (
        <ScStreamTitle>
          <CoreText type={TextType.H4}>{title}</CoreText>
        </ScStreamTitle>
      )}
    </>
  );
};

HomepageBannerContent.displayName = 'HomepageBannerContent';
