import type { FC } from 'react';
import { useCallback } from 'react';
import type {
  RecommendationTrackingParams,
  WithRecommendationTracking,
} from 'tachyon-discovery';
import { useDiscoveryTracking } from 'tachyon-discovery';
import { useEffectOnce } from 'tachyon-utils';
import { FocusableCategoryCard, FocusableStreamCard } from '../../../common';
import type { Stream, StreamOrGameCard } from '../utils';
import { extractStream } from '../utils';

interface RecommendationItemRendererProps {
  cardIndex: number;
  node: WithRecommendationTracking<StreamOrGameCard>;
  onDisplay: (params: RecommendationTrackingParams) => void;
  onFocus: (stream: Stream | null) => void;
}

// istanbul ignore next: trivial
export const RecommendationItemRenderer: FC<RecommendationItemRendererProps> =
  ({ cardIndex, node, onDisplay, onFocus }) => {
    const { onRecommendationItemClick } = useDiscoveryTracking();

    useEffectOnce(() => {
      onDisplay(node.tracking);
    });

    const onClick = useCallback(() => {
      onRecommendationItemClick(node.tracking);
    }, [node.tracking, onRecommendationItemClick]);

    const onFocusHandler = useCallback(() => {
      onFocus(extractStream(node));
    }, [node, onFocus]);

    return node.__typename === 'Game' ? (
      <FocusableCategoryCard
        category={node}
        focusIndex={cardIndex}
        onClick={onClick}
        onFocus={onFocusHandler}
      />
    ) : (
      <FocusableStreamCard
        focusIndex={cardIndex}
        onClick={onClick}
        onFocus={onFocusHandler}
        stream={node}
      />
    );
  };

RecommendationItemRenderer.displayName = 'RecommendationItemRenderer';
