import type { OmitRefType } from 'tachyon-type-library';
import { getGameDisplayName, titleCase } from 'tachyon-utils';
import type { Homepage_title } from '../__generated__/Homepage_title.graphql';

export const GAME_TOKEN = 'Game';
export const TEXT_TOKEN = 'TextToken';
export const STREAMS_DIRECTORY = 'STREAMS_DIRECTORY';

type RecommendationShelfTitle = OmitRefType<Homepage_title>;

export const parseLocalizedTitleTokens = ({
  localizedTitleTokens = [],
  fallbackLocalizedTitle,
}: RecommendationShelfTitle): string[] => {
  const parsedTokens = localizedTitleTokens.reduce<string[]>((acc, token) => {
    const node = token?.node;

    if (node?.__typename === GAME_TOKEN) {
      acc.push(getGameDisplayName(node));
    }

    if (node?.__typename === TEXT_TOKEN) {
      acc.push(node.text);
    }

    return acc;
  }, []);

  const isParsed =
    localizedTitleTokens.length > 0 &&
    localizedTitleTokens.length === parsedTokens.length;
  if (isParsed) {
    return parsedTokens;
  }

  if (fallbackLocalizedTitle) {
    return [fallbackLocalizedTitle];
  }

  return [];
};

export function shelfTitle(title: RecommendationShelfTitle): string {
  return parseLocalizedTitleTokens(title).map(titleCase).join(' ');
}
