import { lorem } from 'faker';
import {
  GAME_TOKEN,
  STREAMS_DIRECTORY,
  TEXT_TOKEN,
  parseLocalizedTitleTokens,
  shelfTitle,
} from '.';

describe(shelfTitle, () => {
  it('parses and title cases the title', () => {
    const title = {
      fallbackLocalizedTitle: 'bar',
      localizedTitleTokens: [
        {
          node: {
            __typename: GAME_TOKEN,
            displayName: 'foo',
            name: lorem.word(),
          } as const,
        },
      ],
    };

    expect(shelfTitle(title)).toEqual('Foo');
  });

  it('empty string when parseLocalizedTitleTokens fails', () => {
    const title = {
      fallbackLocalizedTitle: '',
      localizedTitleTokens: [],
    };

    expect(shelfTitle(title)).toEqual('');
  });
});

describe(parseLocalizedTitleTokens, () => {
  it('game tokens return node displayName', () => {
    expect(
      parseLocalizedTitleTokens({
        fallbackLocalizedTitle: 'Foo',
        localizedTitleTokens: [
          {
            node: {
              __typename: GAME_TOKEN,
              displayName: 'GameFoo',
              name: lorem.word(),
            },
          },
        ],
      }),
    ).toEqual(['GameFoo']);
  });

  it('text tokens return node text', () => {
    expect(
      parseLocalizedTitleTokens({
        fallbackLocalizedTitle: 'Foo',
        localizedTitleTokens: [
          {
            node: {
              __typename: TEXT_TOKEN,
              location: STREAMS_DIRECTORY,
              text: 'StreamsFoo',
            },
          },
        ],
      }),
    ).toEqual(['StreamsFoo']);
  });

  describe('parse failures return fallbackLocalizedTitle', () => {
    it('when localizedTitleTokens is empty', () => {
      expect(
        parseLocalizedTitleTokens({
          fallbackLocalizedTitle: 'Foo',
          localizedTitleTokens: [],
        }),
      ).toEqual(['Foo']);
    });

    it('when localizedTitleTokens has nulls', () => {
      expect(
        parseLocalizedTitleTokens({
          fallbackLocalizedTitle: 'Foo',
          localizedTitleTokens: [
            {
              node: {
                __typename: TEXT_TOKEN,
                location: STREAMS_DIRECTORY,
                text: 'StreamsFoo',
              },
            },
            null,
            {
              node: null,
            },
          ],
        }),
      ).toEqual(['Foo']);
    });

    it('when localizedTitleTokens has unknown types', () => {
      expect(
        parseLocalizedTitleTokens({
          fallbackLocalizedTitle: 'Foo',
          localizedTitleTokens: [
            {
              node: {
                __typename: '%other',
              },
            },
          ],
        }),
      ).toEqual(['Foo']);
    });
  });
});
