import { useIntl } from 'tachyon-intl';
import { GlowJoinTheConversation } from 'tachyon-more-ui';
import type {
  ChannelInitialProps,
  ChannelPathParameters,
} from 'tachyon-page-utils';
import {
  channelPathGetInitialProps,
  defaultPageviewTracking,
  getCurrentUser,
} from 'tachyon-page-utils';
import { safeLogin } from 'tachyon-utils';
import { QRLayout, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

// istanbul ignore next: trivial
export const JoinConversation: StarshotPage<
  ChannelInitialProps,
  ChannelInitialProps,
  ChannelPathParameters
> = ({ queryVariables }) => {
  const { formatMessage } = useIntl();
  const url = new URL(
    `https://www.twitch.tv/${safeLogin(queryVariables.login)}/chat`,
  ).href;
  return (
    <StarshotMain>
      <QRLayout content="second_screen_chat" url={url}>
        <QRLayout.LeftPane
          header={formatMessage('Join the conversation!', 'JoinConversation')}
          subText={formatMessage(
            'Scan the QR code on the right with your mobile device to start chatting...',
            'JoinConversation',
          )}
          svg={<GlowJoinTheConversation />}
        />
      </QRLayout>
    </StarshotMain>
  );
};

JoinConversation.currentUser = getCurrentUser;
JoinConversation.displayName = 'JoinConversation';
JoinConversation.navigationBehavior = () => ({
  displayBackButton: true,
  noFocusableContent: true,
});
JoinConversation.getInitialProps = channelPathGetInitialProps;
JoinConversation.pageviewTracking = defaultPageviewTracking;
