import { QRUrl } from 'tachyon-more-ui';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { JoinConversation } from '.';

const mockUseCurrentUser = { loggedIn: true };
jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: () => mockUseCurrentUser,
}));

describe(JoinConversation, () => {
  const setup = createMountWrapperFactory(JoinConversation, () => ({
    queryVariables: { login: 'foo' },
  }));

  it('shows a QR code linking to chat', () => {
    const { wrapper } = setup();

    expect(wrapper.find(QRUrl)).toHaveProp(
      'url',
      `https://www.twitch.tv/foo/chat`,
    );
  });
});
