import {
  defaultPageviewTracking,
  getCurrentUser,
  notFoundGetInitialProps,
} from 'tachyon-page-utils';
import { NotFoundError } from '../../errors';
import type { StarshotPage } from '../types';

// istanbul ignore next: trivial
export const NotFound: StarshotPage = () => <NotFoundError />;

NotFound.currentUser = getCurrentUser;
NotFound.displayName = 'NotFound';
NotFound.navigationBehavior = () => ({});
NotFound.pageviewTracking = defaultPageviewTracking;

// istanbul ignore next: trivial
NotFound.getInitialProps = (ctx) =>
  notFoundGetInitialProps({ package: 'starshot' }, ctx);
