import type { FC } from 'react';
import styled from 'styled-components';
import {
  AlignItems,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
} from 'twitch-core-ui';
import { TOP_NAV_HEIGHT_REM } from '../../../../config';
import { SearchInputWithHistory } from '../SearchInputWithHistory';

type SearchCTAProps = {
  focusIndex: number;
};

const PAGE_CONTENT_TOP_PADDING = 4;

const ScLayout = styled(Layout)`
  padding-top: ${TOP_NAV_HEIGHT_REM + PAGE_CONTENT_TOP_PADDING}rem;
  width: 50vw;
`;

// Ensure that the input field is rendered in the upper half of the page to
// avoid on-screen keyboards covering the field.
// istanbul ignore next: trivial
export const SearchCTA: FC<SearchCTAProps> = ({ children, focusIndex }) => (
  <ScLayout
    alignItems={AlignItems.Center}
    display={Display.Flex}
    flexDirection={FlexDirection.Column}
    fullHeight
    justifyContent={JustifyContent.Start}
    margin="auto"
  >
    {children}
    <Layout fullWidth padding={{ top: 2 }}>
      <SearchInputWithHistory focusIndex={focusIndex} />
    </Layout>
  </ScLayout>
);

SearchCTA.displayName = 'SearchCTA';
