import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { ShadowedSVG } from 'tachyon-more-ui';
import {
  AlignItems,
  Display,
  Layout,
  SVGAsset,
  TextType,
  Title,
  TitleSize,
} from 'twitch-core-ui';
import { SearchCTA } from '../SearchCTA';
import { SearchResults } from '../SearchResults';
import type { Search_QueryResponse } from '../__generated__/Search_Query.graphql';

interface SearchContentProps {
  content: Search_QueryResponse['searchFor'] | null;
  focusIndex: number;
  searchTerm: string;
}

export const SearchContent: FC<SearchContentProps> = ({
  content,
  focusIndex,
  searchTerm,
}) => {
  const { formatMessage } = useIntl();
  if (!content) {
    return (
      <SearchCTA focusIndex={focusIndex}>
        <Layout alignItems={AlignItems.Center} display={Display.Flex} fullWidth>
          <Layout padding={{ right: 2 }}>
            <ShadowedSVG
              asset={SVGAsset.NavSearch}
              heightRem={5}
              widthRem={5}
            />
          </Layout>
          <Title size={TitleSize.Default} type={TextType.H2}>
            {formatMessage(
              'Find your favorite category or channel:',
              'SearchContent',
            )}
          </Title>
        </Layout>
      </SearchCTA>
    );
  }

  return (
    <SearchResults
      focusIndex={focusIndex}
      results={content}
      searchTerm={searchTerm}
    />
  );
};

SearchContent.displayName = 'SearchContent';
