import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SearchCTA } from '../SearchCTA';
import { SearchResults } from '../SearchResults';
import { SearchContent } from '.';

describe(SearchContent, () => {
  const setup = createShallowWrapperFactory(SearchContent, () => ({
    content: null,
    focusIndex: 0,
    searchTerm: 'therealderekt',
  }));

  it('renders the CTA if no content is provided', () => {
    const { wrapper } = setup({ content: null });
    expect(wrapper.find(SearchCTA)).toExist();
  });

  it('renders SearchResults if content is provided', () => {
    const { wrapper } = setup({ content: {} });
    expect(wrapper.find(SearchResults)).toExist();
  });
});
