import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { InputType } from 'twitch-core-ui';
import { FocusableTextInput } from '../../../common';

type SearchInputProps = {
  focusIndex: number;
  onFocus: () => void;
  onSubmit: (searchTerm: string) => void;
};

// Large enough search queries will cause GQL errors and really long queries
// will also cause layout issues on the results screen. This length should be
// plenty for users searching on a TV device.
const MAX_SEARCH_LENGTH = 64;

// istanbul ignore next: trivial
/**
 * Manages search input. Prevents the underlying input from being focused without
 * an additional click to confirm user intent. This prevents the native keyboard
 * from unexpectedly taking focus which is hard to get out of.
 */
export const SearchInput: FC<SearchInputProps> = (props) => {
  const { formatMessage } = useIntl();

  return (
    <FocusableTextInput
      maxLength={MAX_SEARCH_LENGTH}
      placeholder={formatMessage('Search Twitch...', 'SearchInput')}
      type={InputType.Search}
      {...props}
    />
  );
};

SearchInput.displayName = 'SearchInput';
