import type { FC } from 'react';
import { memo, useCallback } from 'react';
import type { OmitRefType } from 'tachyon-type-library';
import { useEffectOnce } from 'tachyon-utils';
import type { FocusableCategoryCardProps } from '../../../../common';
import { FocusableCategoryCard } from '../../../../common';
import type { SearchResults_gamesItem } from '../__generated__/SearchResults_gamesItem.graphql';
import type { SearchTrackingParams } from '../utils';
import { getGameTrackingParams } from '../utils';

interface FocusableSearchCategoryCardProps
  extends Pick<FocusableCategoryCardProps, 'onFocus'> {
  cardIndex: number;
  node: OmitRefType<SearchResults_gamesItem>;
  onSearchImpressionMemoized: (params: SearchTrackingParams) => void;
  onSearchResultClick: (params: SearchTrackingParams) => void;
  rowPosition: number;
  searchTerm: string;
}

export const FocusableSearchCategoryCardBase: FC<FocusableSearchCategoryCardProps> =
  ({
    cardIndex,
    node,
    onFocus,
    onSearchImpressionMemoized,
    onSearchResultClick,
    rowPosition,
    searchTerm,
  }) => {
    const trackingParams = getGameTrackingParams(
      node,
      cardIndex,
      rowPosition,
      searchTerm,
    );

    useEffectOnce(() => {
      onSearchImpressionMemoized(trackingParams);
    });

    const onClick = useCallback(() => {
      onSearchResultClick(trackingParams);
    }, [onSearchResultClick, trackingParams]);

    return (
      <FocusableCategoryCard
        category={node}
        focusIndex={cardIndex}
        onClick={onClick}
        onFocus={onFocus}
      />
    );
  };

FocusableSearchCategoryCardBase.displayName = 'FocusableSearchCategoryCard';

export const FocusableSearchCategoryCard = memo(
  FocusableSearchCategoryCardBase,
);
