import { datatype, random } from 'faker';
import { act } from 'react-dom/test-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { FocusableCategoryCard } from '../../../../common';
import { FocusableSearchCategoryCardBase as FocusableSearchCategoryCard } from '.';

jest.mock('../../../../common/FocusableCategoryCard', () => ({
  FocusableCategoryCard: jest.fn(() => <div />),
}));

describe(FocusableSearchCategoryCard, () => {
  const setup = createMountWrapperFactory(FocusableSearchCategoryCard, () => ({
    cardIndex: datatype.number(),
    node: {
      ' $fragmentRefs': {
        FocusableCategoryCard_category: true,
      },
      id: datatype.uuid(),
      streams: null,
    },
    onFocus: jest.fn(),
    onSearchImpressionMemoized: jest.fn(),
    onSearchResultClick: jest.fn(),
    rowPosition: datatype.number(),
    searchTerm: random.alphaNumeric(),
  }));

  it('fires onSearchImpression', () => {
    const { props } = setup();
    expect(props.onSearchImpressionMemoized).toHaveBeenCalledTimes(1);
  });

  it('renders a game card', () => {
    const { props, wrapper } = setup();
    const gameCard = wrapper.find(FocusableCategoryCard);

    expect(gameCard).toHaveProp('focusIndex', props.cardIndex);
  });

  it('calls setBackgroundImage on focus', () => {
    const { props, wrapper } = setup();
    expect(props.onFocus).not.toHaveBeenCalled();

    act(() => {
      wrapper.find(FocusableCategoryCard).prop('onFocus')!(props.cardIndex);
    });

    expect(props.onFocus).toHaveBeenCalledWith(props.cardIndex);
  });

  it('calls onSearchResultClick when clicked', () => {
    const { props, wrapper } = setup();
    expect(props.onSearchResultClick).not.toHaveBeenCalled();

    act(() => {
      wrapper.find(FocusableCategoryCard).prop('onClick')!();
    });

    expect(props.onSearchResultClick).toHaveBeenCalledTimes(1);
  });
});
