import type { FC } from 'react';
import { memo, useCallback } from 'react';
import type { OmitRefType } from 'tachyon-type-library';
import { useEffectOnce } from 'tachyon-utils';
import type { FocusableStreamCardProps } from '../../../../common';
import {
  FocusableOfflineChannelCard,
  FocusableStreamCard,
} from '../../../../common';
import { isLiveStream } from '../../utils';
import type { SearchResults_channelsItem } from '../__generated__/SearchResults_channelsItem.graphql';
import type { SearchTrackingParams } from '../utils';
import { getStreamTrackingParams } from '../utils';

type FocusableSearchChannelCardProps = Pick<
  FocusableStreamCardProps,
  'onFocus'
> & {
  cardIndex: number;
  isRelatedContent: boolean;
  node: OmitRefType<SearchResults_channelsItem>;
  onSearchImpressionMemoized: (params: SearchTrackingParams) => void;
  onSearchResultClick: (params: SearchTrackingParams) => void;
  rowPosition: number;
  searchTerm: string;
};

export const FocusableSearchChannelCardBase: FC<FocusableSearchChannelCardProps> =
  ({
    cardIndex,
    isRelatedContent,
    node,
    onFocus,
    onSearchImpressionMemoized,
    onSearchResultClick,
    rowPosition,
    searchTerm,
  }) => {
    const trackingParams = getStreamTrackingParams(
      node,
      cardIndex,
      rowPosition,
      searchTerm,
      isRelatedContent,
    );

    useEffectOnce(() => {
      onSearchImpressionMemoized(trackingParams);
    });

    const onClick = useCallback(() => {
      onSearchResultClick(trackingParams);
    }, [onSearchResultClick, trackingParams]);

    return isLiveStream(node.stream) ? (
      <FocusableStreamCard
        focusIndex={cardIndex}
        onClick={onClick}
        onFocus={onFocus}
        stream={node.stream}
      />
    ) : (
      <FocusableOfflineChannelCard
        channel={node}
        focusIndex={cardIndex}
        onClick={onClick}
        onFocus={onFocus}
      />
    );
  };

FocusableSearchChannelCardBase.displayName = 'FocusableSearchChannelCard';

export const FocusableSearchChannelCard = memo(FocusableSearchChannelCardBase);
