import type { FC } from 'react';
import { memo, useCallback } from 'react';
import type { OmitRefType } from 'tachyon-type-library';
import { useEffectOnce } from 'tachyon-utils';
import type { FocusableStreamCardProps } from '../../../../common';
import { FocusableVodCard } from '../../../../common';
import type { SearchResults_videosItem } from '../__generated__/SearchResults_videosItem.graphql';
import type { SearchTrackingParams } from '../utils';
import { getVideoTrackingParams } from '../utils';

type FocusableSearchVideoCardProps = Pick<
  FocusableStreamCardProps,
  'onFocus'
> & {
  cardIndex: number;
  node: OmitRefType<SearchResults_videosItem>;
  onSearchImpressionMemoized: (params: SearchTrackingParams) => void;
  onSearchResultClick: (params: SearchTrackingParams) => void;
  rowPosition: number;
  searchTerm: string;
};

export const FocusableSearchVideoCardBase: FC<FocusableSearchVideoCardProps> =
  ({
    cardIndex,
    node,
    onFocus,
    onSearchImpressionMemoized,
    onSearchResultClick,
    rowPosition,
    searchTerm,
  }) => {
    const trackingParams = getVideoTrackingParams(
      node,
      cardIndex,
      rowPosition,
      searchTerm,
    );

    useEffectOnce(() => {
      onSearchImpressionMemoized(trackingParams);
    });

    const onClick = useCallback(() => {
      onSearchResultClick(trackingParams);
    }, [onSearchResultClick, trackingParams]);

    return (
      <FocusableVodCard
        focusIndex={cardIndex}
        onClick={onClick}
        onFocus={onFocus}
        video={node}
      />
    );
  };

FocusableSearchVideoCardBase.displayName = 'FocusableSearchVideoCard';

export const FocusableSearchVideoCard = memo(FocusableSearchVideoCardBase);
