import { act } from '@testing-library/react-hooks';
import { datatype, internet, lorem } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { FocusableVodCard } from '../../../../common';
import { FocusableSearchVideoCardBase as FocusableSearchVideoCard } from '.';

jest.mock('../../../../common', () => ({
  FocusableSearchVideoCard: jest.fn(() => <div />),
  FocusableVodCard: jest.fn(() => <div />),
}));

describe(FocusableSearchVideoCard, () => {
  const setup = createMountWrapperFactory(FocusableSearchVideoCard, () => ({
    cardIndex: datatype.number(),
    node: {
      ' $fragmentRefs': {
        FocusableVodCard_video: true,
      },
      game: {
        id: datatype.uuid(),
      },
      id: datatype.uuid(),
      previewThumbnailURL: internet.url(),
    },
    onFocus: jest.fn(),
    onSearchImpressionMemoized: jest.fn(),
    onSearchResultClick: jest.fn(),
    rowPosition: datatype.number(),
    searchTerm: lorem.word(),
  }));

  describe('renders', () => {
    it('a video card component', () => {
      const { props, wrapper } = setup();
      const streamCard = wrapper.find(FocusableVodCard);

      expect(streamCard).toExist();
      expect(streamCard).toHaveProp('focusIndex', props.cardIndex);
    });

    it('fires onSearchImpression', () => {
      const { props } = setup();
      expect(props.onSearchImpressionMemoized).toHaveBeenCalledTimes(1);
    });
  });

  it('calls setBackgroundImage on focus', () => {
    const { props, wrapper } = setup();
    expect(props.onFocus).not.toHaveBeenCalled();

    act(() => {
      wrapper.find(FocusableVodCard).prop('onFocus')!(props.cardIndex);
    });

    expect(props.onFocus).toHaveBeenCalledWith(props.cardIndex);
  });

  it('calls onSearchResultClick when clicked', () => {
    const { props, wrapper } = setup();
    expect(props.onSearchResultClick).not.toHaveBeenCalled();

    act(() => {
      wrapper.find(FocusableVodCard).prop('onClick')!();
    });

    expect(props.onSearchResultClick).toHaveBeenCalledTimes(1);
  });
});
