import type { FC } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import { TextType, Title, TitleSize, WordBreak } from 'twitch-core-ui';
import { DarkThemeMap } from 'twitch-core-ui-tokens';

// istanbul ignore next: trivial
const ScResultsTitle = styled(Title)`
  color: ${DarkThemeMap['color-text-alt-2']};
`;

export type SearchBannerContentProps = {
  // search banner content does not update in response to navigation
  data: undefined;
  searchTerm: string;
};

export const SearchBannerContent: FC<SearchBannerContentProps> = ({
  searchTerm,
}) => {
  const { formatMessage } = useIntl();

  return (
    <>
      <ScResultsTitle size={TitleSize.ExtraSmall} type={TextType.H2}>
        {formatMessage('Showing results for:', 'SearchResults')}
      </ScResultsTitle>
      <Title
        size={TitleSize.Default}
        type={TextType.H2}
        wordBreak={WordBreak.BreakAll}
      >
        {searchTerm}
      </Title>
    </>
  );
};
SearchBannerContent.displayName = 'SearchBannerContent';
