import type {
  SearchClickResultParams,
  SearchResultImpressionParams,
} from 'tachyon-discovery';
import { SearchCategory } from 'tachyon-discovery';
import { convertToUnsafeID } from 'tachyon-relay';
import type { OmitRefType } from 'tachyon-type-library';
import { isLiveStream } from '../utils';
import type { SearchResults_channelsItem } from './__generated__/SearchResults_channelsItem.graphql';
import type { SearchResults_videosItem } from './__generated__/SearchResults_videosItem.graphql';

export interface SearchTrackingParams
  extends SearchClickResultParams,
    SearchResultImpressionParams {}

export function getGameTrackingParams(
  node: { id: string | undefined },
  cardIdx: number,
  itemRow: number,
  searchTerm: string,
): SearchTrackingParams {
  return {
    contentID: convertToUnsafeID(node.id),
    contentType: SearchCategory.Games,
    itemIndex: cardIdx,
    itemRow,
    query: searchTerm,
    subSection: SearchCategory.Games,
    subSectionPosition: itemRow,
  };
}

export function getStreamTrackingParams(
  node: OmitRefType<SearchResults_channelsItem>,
  cardIdx: number,
  itemRow: number,
  searchTerm: string,
  isRelatedContent: boolean,
): SearchTrackingParams {
  return {
    contentID: convertToUnsafeID(node.id),
    contentType: SearchCategory.Streams,
    gameID: convertToUnsafeID(node.stream?.game?.id),
    isLive: isLiveStream(node.stream),
    itemIndex: cardIdx,
    itemRow,
    query: searchTerm,
    subSection: isRelatedContent
      ? SearchCategory.RelatedChannels
      : SearchCategory.Streams,
    subSectionPosition: itemRow,
  };
}

export function getVideoTrackingParams(
  node: OmitRefType<SearchResults_videosItem>,
  cardIdx: number,
  itemRow: number,
  searchTerm: string,
): SearchTrackingParams {
  return {
    contentID: convertToUnsafeID(node.id),
    contentType: SearchCategory.Videos,
    gameID: convertToUnsafeID(node.game?.id),
    itemIndex: cardIdx,
    itemRow,
    query: searchTerm,
    subSection: SearchCategory.Videos,
    subSectionPosition: itemRow,
  };
}
