import { isValidObject } from 'tachyon-relay';
import type { SearchResults_results } from '../SearchResults';

type ChannelsConnection = NonNullable<SearchResults_results['channels']>;
type Channels = NonNullable<ChannelsConnection['items']>;
export type Channel = Channels[0];
export type LiveStream = NonNullable<Channel['stream']>;

export type Game = NonNullable<
  NonNullable<SearchResults_results['games']>['items']
>[0];

export type Video = NonNullable<
  NonNullable<SearchResults_results['videos']>['items']
>[0];

export function isLiveStream(stream: Channel['stream']): stream is LiveStream {
  return isValidObject(stream);
}

export function channelBackgroundImageSrc(channel: Channel): string | null {
  if (isLiveStream(channel.stream)) {
    return channel.stream.previewImageURL;
  }
  return channel.bannerImageURL ?? null;
}
