import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { RouteName } from '../../../routing';
import { FocusableTextButton } from '../../common';
import { SettingsChannelNotInterested } from '.';

const mockRouterPush = jest.fn();
const mockRouterBack = jest.fn();

jest.mock('../../../routing', () => ({
  ...jest.requireActual('../../../routing'),
  useTachyonRouter: () => ({
    back: mockRouterBack,
    push: mockRouterPush,
  }),
}));

const mockUseNotInterested = jest.fn();

jest.mock('../../../hooks', () => ({
  useNotInterested: () => mockUseNotInterested,
}));

describe(SettingsChannelNotInterested, () => {
  const setup = createShallowWrapperFactory(
    SettingsChannelNotInterested,
    () => ({
      channel: {
        displayName: 'TheRealDerekt',
        id: '1234',
        login: 'therealderekt',
      },
      currentUser: null,
      queryVariables: {
        login: 'therealderekt',
      },
    }),
  );

  beforeEach(() => {
    jest.resetAllMocks();
  });

  describe('when the go back button is pressed', () => {
    it('sends the user to the previous page', () => {
      const { wrapper } = setup();
      expect(mockRouterBack).not.toHaveBeenCalled();

      wrapper.find(FocusableTextButton).at(0).simulate('click');
      expect(mockRouterBack).toHaveBeenCalledTimes(1);
    });
  });

  describe('when the not interested option is pressed', () => {
    it('triggers the not interested mutation and sends the user to the homepage', () => {
      const { wrapper } = setup();
      expect(mockRouterPush).not.toHaveBeenCalled();
      expect(mockUseNotInterested).not.toHaveBeenCalled();

      wrapper.find(FocusableTextButton).at(1).simulate('click');
      expect(mockUseNotInterested).toHaveBeenCalledTimes(1);
      expect(mockRouterPush).toHaveBeenCalledTimes(1);
      expect(mockRouterPush).toHaveBeenLastCalledWith({
        route: RouteName.Homepage,
      });
    });
  });
});
