import { useIntl } from 'tachyon-intl';
import { GlowReportChannel } from 'tachyon-more-ui';
import type {
  ChannelInitialProps,
  ChannelPathParameters,
} from 'tachyon-page-utils';
import {
  channelPathGetInitialProps,
  defaultPageviewTracking,
  getCurrentUser,
} from 'tachyon-page-utils';
import { QRLayout, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

type SettingsChannelReportInitialProps = ChannelInitialProps;

type SettingsChannelReportProps = SettingsChannelReportInitialProps;

// istanbul ignore next: trivial
export const SettingsChannelReport: StarshotPage<
  SettingsChannelReportInitialProps,
  SettingsChannelReportProps,
  ChannelPathParameters
> = ({ queryVariables }) => {
  const { formatMessage } = useIntl();
  const link = new URL(`https://www.twitch.tv/${queryVariables.login}/report`)
    .href;

  return (
    <StarshotMain>
      <QRLayout content="report_channel_page" url={link}>
        <QRLayout.LeftPane
          header={formatMessage('Report Channel?', 'ReportChannelPage')}
          subText={formatMessage(
            'Scan the QR code to open the reporting flow on your mobile device',
            'ReportChannelPage',
          )}
          svg={<GlowReportChannel />}
        />
      </QRLayout>
    </StarshotMain>
  );
};

SettingsChannelReport.currentUser = getCurrentUser;
SettingsChannelReport.displayName = 'ReportChannelPage';
SettingsChannelReport.getInitialProps = channelPathGetInitialProps;
SettingsChannelReport.navigationBehavior = () => ({
  displayBackButton: true,
  displayNavMenu: true,
  noFocusableContent: true,
});
SettingsChannelReport.pageviewTracking = defaultPageviewTracking;
