import {
  mockCommonDevelopmentEnvironment,
  mockCommonProductionEnvironment,
  useStaticEnvironment,
} from 'tachyon-environment';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Redirect } from '../../../routing';
import { SettingsMenu } from '../../common';
import { SettingsDebugExperimentManager } from '.';

jest.mock('tachyon-experiments', () => ({
  ...jest.requireActual('tachyon-experiments'),
  useDangerousExperimentsConfig: () => ({
    experimentGroupsForUser: {
      experiment1: { name: 'experiment1' },
      experiment2: { name: 'experiment2' },
    },
  }),
}));

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));

const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;

describe('ExperimentManager', () => {
  const setup = createShallowWrapperFactory(SettingsDebugExperimentManager);

  beforeEach(() => {
    mockUseStaticEnvironment.mockReturnValue({
      common: mockCommonDevelopmentEnvironment(),
    });
  });

  it('redirects to the Homepage in production', () => {
    mockUseStaticEnvironment.mockReturnValue({
      common: mockCommonProductionEnvironment(),
    });

    const { wrapper } = setup();
    expect(wrapper.find(Redirect)).toExist();
  });

  it('does not renders not found in non-production', () => {
    const { wrapper } = setup();

    // 2 experiments + reload button
    expect(wrapper.find(SettingsMenu).prop('items')).toHaveLength(3);
  });
});
