import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { VerticalNav } from 'tachyon-tv-nav';
import {
  CoreButtonType,
  Display,
  FlexDirection,
  InputType,
  Layout,
} from 'twitch-core-ui';
import { useTachyonRouter } from '../../../routing';
import {
  FocusableTextButton,
  FocusableTextInput,
  SettingsPrompt,
  StarshotMain,
} from '../../common';
import type { StarshotPage } from '../types';

// istanbul ignore next: trivial
export const SettingsDebugPathNavigator: StarshotPage = () => {
  const { back } = useTachyonRouter();

  const onPathSubmit = (appPath: string) => {
    const formattedPath = appPath.charAt(0) !== '/' ? `/${appPath}` : appPath;
    window.location.pathname = formattedPath;
  };

  return (
    <StarshotMain>
      <SettingsPrompt title="Input An App Path">
        <VerticalNav elementCount={2} focusIndex={0} takeFocusOnFirstRender>
          <Layout display={Display.Flex} flexDirection={FlexDirection.Column}>
            <Layout padding={{ bottom: 1 }}>
              <FocusableTextInput
                focusIndex={0}
                onSubmit={onPathSubmit}
                placeholder="videos/1234"
                type={InputType.Text}
              />
            </Layout>
            <FocusableTextButton
              focusIndex={1}
              focusedType={CoreButtonType.Text}
              onClick={back}
            >
              {'Go back'}
            </FocusableTextButton>
          </Layout>
        </VerticalNav>
      </SettingsPrompt>
    </StarshotMain>
  );
};

SettingsDebugPathNavigator.currentUser = getCurrentUser;
SettingsDebugPathNavigator.displayName = 'SettingsDebugPathNavigator';
SettingsDebugPathNavigator.navigationBehavior = () => ({
  displayNavMenu: true,
});
SettingsDebugPathNavigator.pageviewTracking = defaultPageviewTracking;
