import { useIntl } from 'tachyon-intl';
import {
  GlowCoolCatSvg,
  TwitchEntityInformationLink,
  getEntityInformation,
} from 'tachyon-more-ui';
import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { CoreText, FontSize, Layout } from 'twitch-core-ui';
import { SettingsPrompt, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

// istanbul ignore next: trivial
export const SettingsEntityInformation: StarshotPage = () => {
  const { formatMessage } = useIntl();

  const { BusinessInfo, TermsOfSale } = TwitchEntityInformationLink;
  const { address, hosting, phone, representative, tradename } =
    getEntityInformation(formatMessage);

  return (
    <StarshotMain>
      <SettingsPrompt
        svg={<GlowCoolCatSvg />}
        title={formatMessage('Entity Information', 'SettingsEntityInformation')}
      >
        <Layout>
          <CoreText fontSize={FontSize.Size5}>{tradename}</CoreText>
          <CoreText fontSize={FontSize.Size5}>{representative}</CoreText>
          <CoreText fontSize={FontSize.Size5}>{address}</CoreText>
          <CoreText fontSize={FontSize.Size5}>{phone}</CoreText>
          <CoreText fontSize={FontSize.Size5}>{hosting}</CoreText>
        </Layout>
        <Layout margin={{ top: 2 }}>
          <CoreText fontSize={FontSize.Size5}>
            {formatMessage('For Terms of Sale visit:', 'SettingsPage')}
          </CoreText>
          <CoreText fontSize={FontSize.Size5}>{TermsOfSale}</CoreText>
        </Layout>
        <Layout margin={{ top: 2 }}>
          <CoreText fontSize={FontSize.Size5}>
            {formatMessage('For Business Info visit:', 'SettingsPage')}
          </CoreText>
          <CoreText fontSize={FontSize.Size5}>{BusinessInfo}</CoreText>
        </Layout>
      </SettingsPrompt>
    </StarshotMain>
  );
};

SettingsEntityInformation.currentUser = getCurrentUser;
SettingsEntityInformation.displayName = 'SettingsEntityInformation';
SettingsEntityInformation.navigationBehavior = () => ({
  displayBackButton: true,
  displayNavMenu: true,
  noFocusableContent: true,
});
SettingsEntityInformation.pageviewTracking = defaultPageviewTracking;
