import { graphql } from 'react-relay/hooks';
import { PageviewMedium } from 'tachyon-discovery';
import { useIntl } from 'tachyon-intl';
import { GlowNotInterestedSvg } from 'tachyon-more-ui';
import type { GameInitialProps, GamePathParameters } from 'tachyon-page-utils';
import {
  defaultPageviewTracking,
  gameGetInitialProps,
  getCurrentUser,
} from 'tachyon-page-utils';
import { HorizontalNav } from 'tachyon-tv-nav';
import { CoreButtonType, Display, FlexDirection, Layout } from 'twitch-core-ui';
import { useNotInterested } from '../../../hooks';
import { RouteName, useTachyonRouter } from '../../../routing';
import {
  FocusableTextButton,
  SettingsPrompt,
  StarshotMain,
} from '../../common';
import type { StarshotPage } from '../types';
import type { SettingsGameNotInterested_QueryResponse } from './__generated__/SettingsGameNotInterested_Query.graphql';

export type SettingsGameNotInterestedProps = GameInitialProps &
  SettingsGameNotInterested_QueryResponse;

// istanbul ignore next: trivial
export const SettingsGameNotInterested: StarshotPage<
  GameInitialProps,
  SettingsGameNotInterestedProps,
  GamePathParameters
> = ({ game, queryVariables }) => {
  const { formatMessage } = useIntl();
  const { back, push } = useTachyonRouter();
  const notInterested = useNotInterested({
    itemID: game?.id ?? '',
    itemType: 'CATEGORY',
    sourceItemPage: PageviewMedium.Browse,
    sourceItemRequestID: '',
    sourceItemTrackingID: '',
  });

  return (
    <StarshotMain>
      <SettingsPrompt
        subHeading={formatMessage(
          'We will no longer recommend {category} to you.',
          { category: game?.name ?? queryVariables.gameAlias },
          'SettingsGameNotInterested',
        )}
        svg={<GlowNotInterestedSvg />}
        title={formatMessage('Are you sure?', 'SettingsGameNotInterested')}
      >
        <HorizontalNav elementCount={2} focusIndex={0} takeFocusOnFirstRender>
          <Layout display={Display.Flex} flexDirection={FlexDirection.Row}>
            <FocusableTextButton
              focusIndex={0}
              focusedType={CoreButtonType.Text}
              onClick={back}
            >
              {formatMessage('Go back', 'SettingsGameNotInterested')}
            </FocusableTextButton>
            <FocusableTextButton
              focusIndex={1}
              focusedType={CoreButtonType.Destructive}
              onClick={() => {
                notInterested();
                push({ route: RouteName.Homepage });
              }}
            >
              {formatMessage("Yes, I'm sure", 'SettingsGameNotInterested')}
            </FocusableTextButton>
          </Layout>
        </HorizontalNav>
      </SettingsPrompt>
    </StarshotMain>
  );
};

SettingsGameNotInterested.currentUser = getCurrentUser;
SettingsGameNotInterested.displayName = 'SettingsGameNotInterested';
SettingsGameNotInterested.getInitialProps = gameGetInitialProps;
SettingsGameNotInterested.navigationBehavior = () => ({
  displayNavMenu: true,
});
SettingsGameNotInterested.pageviewTracking = defaultPageviewTracking;

SettingsGameNotInterested.query = graphql`
  query SettingsGameNotInterested_Query($gameAlias: String!) {
    currentUser {
      ...types_currentUser @relay(mask: false)
    }
    game(name: $gameAlias) {
      id
      name
    }
  }
`;
