import { useIntl } from 'tachyon-intl';
import { GlowSettingsHelp } from 'tachyon-more-ui';
import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { QRLayout, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

const url = 'https://help.twitch.tv';

// istanbul ignore next: trivial
export const SettingsHelp: StarshotPage = () => {
  const { formatMessage } = useIntl();

  return (
    <StarshotMain>
      <QRLayout content="help_page" url={url}>
        <QRLayout.LeftPane
          header={formatMessage('Need Help?', 'SettingsHelp')}
          subText={formatMessage(
            'Scan the QR code to open {url} on your mobile device',
            { url },
            'SettingsHelp',
          )}
          svg={<GlowSettingsHelp />}
        />
      </QRLayout>
    </StarshotMain>
  );
};

SettingsHelp.currentUser = getCurrentUser;
SettingsHelp.displayName = 'SettingsHelp';
SettingsHelp.navigationBehavior = () => ({
  displayBackButton: true,
  displayNavMenu: true,
  noFocusableContent: true,
});
SettingsHelp.pageviewTracking = defaultPageviewTracking;
