import { useIntl } from 'tachyon-intl';
import { GlowLockedLockSvg } from 'tachyon-more-ui';
import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { QRLayout, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

const url = 'https://www.twitch.tv/p/legal/privacy-notice';

// istanbul ignore next: trivial
export const SettingsPrivacy: StarshotPage = () => {
  const { formatMessage } = useIntl();

  return (
    <StarshotMain>
      <QRLayout content="privacy_page" url={url}>
        <QRLayout.LeftPane
          header={formatMessage('Privacy Policy', 'SettingsPrivacy')}
          subText={formatMessage(
            'Scan the QR code to open {url} on your mobile device ',
            { url },
            'SettingsPrivacy',
          )}
          svg={<GlowLockedLockSvg />}
        />
      </QRLayout>
    </StarshotMain>
  );
};

SettingsPrivacy.currentUser = getCurrentUser;
SettingsPrivacy.displayName = 'SettingsPrivacy';
SettingsPrivacy.navigationBehavior = () => ({
  displayBackButton: true,
  displayNavMenu: true,
  noFocusableContent: true,
});
SettingsPrivacy.pageviewTracking = defaultPageviewTracking;
