import { useCurrentUser } from 'tachyon-auth';
import { useIntl } from 'tachyon-intl';
import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { useSearchHistory } from '../../../hooks';
import {
  RouteName,
  renderTachyonLink,
  useTachyonRouter,
} from '../../../routing';
import type { SettingsMenuOption } from '../../common';
import { SettingsMenu, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

export const SettingsProfile: StarshotPage = () => {
  const { formatMessage } = useIntl();
  const { back, push } = useTachyonRouter();
  const { loggedIn, logout } = useCurrentUser();
  const { clearHistory } = useSearchHistory();
  // istanbul ignore next: trivial
  const onClickSignOut = () => {
    logout();
    clearHistory();
    push({ route: RouteName.Homepage });
  };

  const menuOptions: SettingsMenuOption[] = [
    loggedIn
      ? {
          heading: formatMessage('Sign Out', 'SettingsProfile'),
          interactive: {
            onClick: onClickSignOut,
          },
        }
      : {
          heading: formatMessage('Sign In', 'SettingsProfile'),
          interactive: {
            linkTo: '/deferToRenderLink',
            renderLink: renderTachyonLink({
              route: RouteName.Login,
            }),
          },
        },
    {
      heading: formatMessage('Go back', 'SettingsProfile'),
      interactive: {
        onClick: back,
      },
    },
  ];

  return (
    <StarshotMain>
      <SettingsMenu items={menuOptions} />
    </StarshotMain>
  );
};

SettingsProfile.currentUser = getCurrentUser;
SettingsProfile.displayName = 'SettingsProfile';
SettingsProfile.navigationBehavior = () => ({ displayNavMenu: true });
SettingsProfile.pageviewTracking = defaultPageviewTracking;
