import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SettingsMenu } from '../../common';
import { SettingsProfile } from '.';

let mockUseCurrentUser = { loggedIn: true };
jest.mock('tachyon-auth', () => ({
  ...jest.requireActual('tachyon-auth'),
  useCurrentUser: () => mockUseCurrentUser,
}));

describe(SettingsProfile, () => {
  const setup = createShallowWrapperFactory(SettingsProfile);

  it("shows 'Sign In' button when logged out", () => {
    mockUseCurrentUser = { loggedIn: false };
    const { wrapper } = setup();

    expect(wrapper.find(SettingsMenu).prop('items')).toContainEqual(
      expect.objectContaining({ heading: 'Sign In' }),
    );
  });

  it("shows 'Sign Out' button when logged in", () => {
    mockUseCurrentUser = { loggedIn: true };
    const { wrapper } = setup();

    expect(wrapper.find(SettingsMenu).prop('items')).toContainEqual(
      expect.objectContaining({ heading: 'Sign Out' }),
    );
  });
});
