import { useIntl } from 'tachyon-intl';
import { GlowSettingsTermsOfService } from 'tachyon-more-ui';
import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { QRLayout, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

const url = 'https://www.twitch.tv/legal/terms-of-service';

// istanbul ignore next: trivial
export const SettingsTermsOfService: StarshotPage = () => {
  const { formatMessage } = useIntl();

  return (
    <StarshotMain>
      <QRLayout content="tos_page" url={url}>
        <QRLayout.LeftPane
          header={formatMessage('Terms Of Service', 'SettingsTermsOfService')}
          subText={formatMessage(
            'Scan the QR code to open {url} on your mobile device',
            { url },
            'SettingsTermsOfService',
          )}
          svg={<GlowSettingsTermsOfService />}
        />
      </QRLayout>
    </StarshotMain>
  );
};

SettingsTermsOfService.currentUser = getCurrentUser;
SettingsTermsOfService.displayName = 'SettingsTermsOfService';
SettingsTermsOfService.navigationBehavior = () => ({
  displayBackButton: true,
  displayNavMenu: true,
  noFocusableContent: true,
});
SettingsTermsOfService.pageviewTracking = defaultPageviewTracking;
