import { useIntl } from 'tachyon-intl';
import { GlowReportChannel } from 'tachyon-more-ui';
import type { VodInitialProps, VodPathParameters } from 'tachyon-page-utils';
import {
  defaultPageviewTracking,
  getCurrentUser,
  vodGetInitialProps,
} from 'tachyon-page-utils';
import { QRLayout, StarshotMain } from '../../common';
import type { StarshotPage } from '../types';

type SettingsVodReportInitialProps = VodInitialProps;

type SettingsVodReportProps = SettingsVodReportInitialProps;

// istanbul ignore next: trivial
export const SettingsVodReport: StarshotPage<
  SettingsVodReportInitialProps,
  SettingsVodReportProps,
  VodPathParameters
> = ({ queryVariables }) => {
  const { formatMessage } = useIntl();
  const link = new URL(`https://www.twitch.tv/videos/${queryVariables.videoId}`)
    .href;

  return (
    <StarshotMain>
      <QRLayout content="report_vod_page" url={link}>
        <QRLayout.LeftPane
          header={formatMessage('Report Video?', 'ReportVodPage')}
          subText={formatMessage(
            'Scan the QR code to report this video using the Twitch mobile app, or visit the URL in your desktop browser',
            'ReportVodPage',
          )}
          svg={<GlowReportChannel />}
        />
      </QRLayout>
    </StarshotMain>
  );
};

SettingsVodReport.currentUser = getCurrentUser;
SettingsVodReport.displayName = 'ReportVodPage';
SettingsVodReport.getInitialProps = vodGetInitialProps;
SettingsVodReport.navigationBehavior = () => ({
  displayBackButton: true,
  displayNavMenu: true,
});
SettingsVodReport.pageviewTracking = defaultPageviewTracking;
