import { usePlaybackTime } from 'pulsar';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { MutedSegmentPopupBase } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlaybackTime: jest.fn(),
}));
const mockUsePlaybackTime = usePlaybackTime as jest.Mock;

describe(MutedSegmentPopupBase, () => {
  let connection: any = null;

  const setup = createShallowWrapperFactory(MutedSegmentPopupBase, () => ({
    muteInfo: {
      ' $fragmentRefs': { MutedSegmentPopup_muteInfo: true },
      ' $refType': 'MutedSegmentPopup_muteInfo',
      muteInfo: {
        mutedSegmentConnection: connection,
      },
    },
  }));

  it('returns null when there are no muted segments', () => {
    connection = null;
    mockUsePlaybackTime.mockReturnValueOnce(0);

    const { wrapper } = setup();
    expect(wrapper).toBeEmptyRender();
  });

  it('renders while inside a muted segment', () => {
    connection = { nodes: [{ duration: 10, offset: 10 }] };

    mockUsePlaybackTime.mockReturnValueOnce(0);
    const { wrapper } = setup();
    wrapper.setProps({});
    expect(wrapper).toBeEmptyRender();

    mockUsePlaybackTime.mockReturnValueOnce(15);
    wrapper.setProps({});
    expect(wrapper).not.toBeEmptyRender();

    mockUsePlaybackTime.mockReturnValueOnce(30);
    wrapper.setProps({});
    expect(wrapper).toBeEmptyRender();
  });
});
