import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../../routing';
import { FocusableIconButton } from '../../../../../common';

type VodSettingsButtonProps = {
  focusIndex: number;
  id: string;
};

// istanbul ignore next: trivial
export const VodSettingsButton: FC<VodSettingsButtonProps> = ({
  focusIndex,
  id,
}) => {
  const { formatMessage } = useIntl();

  return (
    <FocusableIconButton
      aria-label={formatMessage('Vod Settings', 'BottomControls')}
      focusIndex={focusIndex}
      icon={SVGAsset.NavMore}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.SettingsVod,
        routeParams: { id },
      })}
    />
  );
};

VodSettingsButton.displayName = 'VodSettingsButton';
