import { datatype } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { HorizontalNav } from 'tachyon-tv-nav';
import { useFollow } from '../../../../../hooks';
import { FocusableFollowButton, PlaybackInfo } from '../../../../common';
import { QualitySelectButton } from '../../../../player';
import { VodSettingsButton } from './VodSettingsButton';
import { BottomControlsBase } from '.';

jest.mock('../../../../../hooks');
const mockFollow = useFollow as jest.Mock;

describe(BottomControlsBase, () => {
  const setup = createShallowWrapperFactory(BottomControlsBase, () => ({
    currentUser: {
      ' $refType': 'VodBottomControls_currentUser',
      id: datatype.uuid(),
    },
    focusIndex: 0,
    video: {
      ' $refType': 'VodBottomControls_video',
      game: {
        displayName: 'Test game',
      },
      id: '123412341',
      owner: {
        ' $fragmentRefs': {
          FocusableFollowButton_channel: true,
          PlaybackInfo_channel: true,
        },
        id: datatype.uuid(),
        login: 'therealderekt',
        self: null,
      },
      recordedAt: '2021-03-30T11:39:13Z',
      title: 'Test title',
      viewCount: datatype.number(),
    },
    visible: true,
  }));

  beforeEach(() => {
    mockFollow.mockReset();
    mockFollow.mockReturnValue({ following: false });
  });

  it('does not render the video info if the owner is null', () => {
    const { wrapper } = setup({ video: { owner: null } });
    expect(wrapper.find(PlaybackInfo)).not.toExist();
  });

  it('does not render the follow button if the user is already following', () => {
    mockFollow.mockReturnValue({ following: true });
    const { wrapper } = setup();
    expect(wrapper.find(FocusableFollowButton)).not.toExist();
  });

  it('always renders the channel settings button', () => {
    const { wrapper } = setup();
    expect(wrapper.find(VodSettingsButton)).toExist();
  });

  it('assigns expected focusIndex values when all interactables are rendered', () => {
    mockFollow.mockReturnValue({ following: false });

    const { wrapper } = setup();
    expect(wrapper.find(HorizontalNav)).toHaveProp({ elementCount: 4 });
    expect(wrapper.find(PlaybackInfo)).toHaveProp({ focusIndex: 0 });
    expect(wrapper.find(VodSettingsButton)).toHaveProp({
      focusIndex: 1,
    });
    expect(wrapper.find(FocusableFollowButton)).toHaveProp({ focusIndex: 2 });
    expect(wrapper.find(QualitySelectButton)).toHaveProp({ focusIndex: 3 });
  });
});
